/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.client.util.math;

import dev.imb11.fog.api.FogColors;
import dev.imb11.fog.client.FogManager;
import dev.imb11.fog.client.util.color.Color;
import dev.imb11.fog.config.FogConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EnvironmentCalculations {
    public static FogManager.FogSettings apply(float undergroundFactor, FogManager.FogSettings settings, float tickDelta) {
        return EnvironmentCalculations.fixElytraColor(EnvironmentCalculations.applyCaveFog(undergroundFactor, settings), tickDelta, Minecraft.getInstance(), Minecraft.getInstance().player, Minecraft.getInstance().level);
    }

    private static @NotNull FogManager.FogSettings applyCaveFog(float undergroundFactor, FogManager.FogSettings settings) {
        FogColors belowGroundColors = FogColors.DEFAULT_CAVE;
        Color belowColor = belowGroundColors.getNightColor();
        float fogColorR = Mth.lerp((float)undergroundFactor, (float)((float)belowColor.red / 255.0f), (float)settings.fogRed());
        float fogColorG = Mth.lerp((float)undergroundFactor, (float)((float)belowColor.green / 255.0f), (float)settings.fogGreen());
        float fogColorB = Mth.lerp((float)undergroundFactor, (float)((float)belowColor.blue / 255.0f), (float)settings.fogBlue());
        return new FogManager.FogSettings(settings.fogStart(), settings.fogEnd(), fogColorR, fogColorG, fogColorB);
    }

    public static FogManager.FogSettings fixElytraColor(FogManager.FogSettings input, float tickDelta, Minecraft client, LocalPlayer player, ClientLevel world) {
        if (!FogConfig.getInstance().enableHighAltitudeFogColorInfluence) {
            return input;
        }
        float fogColorR = input.fogRed();
        float fogColorG = input.fogGreen();
        float fogColorB = input.fogBlue();
        int surfaceTopLevel = world.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)player.getX(), (int)player.getZ());
        int viewCutoff = surfaceTopLevel + (Integer)client.options.renderDistance().get() * 32;
        int distancePastCutoff = (int)(player.getY() - (double)viewCutoff);
        if (client.player.getY() > (double)viewCutoff) {
            float percentageCutoff = Mth.clamp((float)((float)distancePastCutoff / 25.0f), (float)0.0f, (float)1.0f);
            Vec3 skyColour = client.level.getSkyColor(player.position(), tickDelta);
            fogColorR = (float)Mth.lerp((double)percentageCutoff, (double)fogColorR, (double)skyColour.x);
            fogColorG = (float)Mth.lerp((double)percentageCutoff, (double)fogColorG, (double)skyColour.y);
            fogColorB = (float)Mth.lerp((double)percentageCutoff, (double)fogColorB, (double)skyColour.z);
        }
        return new FogManager.FogSettings(input.fogStart(), input.fogEnd(), fogColorR, fogColorG, fogColorB);
    }
}

