/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.client.util.player;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerUtil {
    private static boolean isPlayerAboveGroundCachedResult = false;
    private static long lastPlayerAboveGroundCheckTime = -1L;

    public static boolean isPlayerAboveGround(LocalPlayer clientPlayerEntity) {
        if (System.currentTimeMillis() - lastPlayerAboveGroundCheckTime < 250L) {
            return isPlayerAboveGroundCachedResult;
        }
        lastPlayerAboveGroundCheckTime = System.currentTimeMillis();
        isPlayerAboveGroundCachedResult = PlayerUtil.isPlayerAboveGroundImpl(clientPlayerEntity);
        return isPlayerAboveGroundCachedResult;
    }

    private static boolean isPlayerAboveGroundImpl(@NotNull LocalPlayer clientPlayerEntity) {
        if (clientPlayerEntity.isUnderWater()) {
            return true;
        }
        @Nullable ClientLevel clientWorld = clientPlayerEntity.clientLevel;
        if (clientWorld == null) {
            return true;
        }
        double x = clientPlayerEntity.getX();
        double z = clientPlayerEntity.getZ();
        double y = clientPlayerEntity.getEyeY();
        int points = 10;
        int undergroundPoints = 0;
        for (int i = 0; i < points; ++i) {
            double dx = (Math.random() - 0.5) * 5.0;
            double dz = (Math.random() - 0.5) * 5.0;
            float topY = clientWorld.getHeight(Heightmap.Types.WORLD_SURFACE_WG, (int)(x + dx), (int)(z + dz));
            float seaLevel = (float)clientWorld.getSeaLevel() - 0.25f;
            if (!(y < (double)(topY = Math.max(topY, seaLevel))) || !(y < (double)seaLevel)) continue;
            ++undergroundPoints;
        }
        int topY = clientWorld.getHeight(Heightmap.Types.WORLD_SURFACE_WG, (int)x, (int)z);
        int seaLevel = clientWorld.getSeaLevel();
        if (y < (double)topY && y < (double)((float)seaLevel - 0.25f)) {
            ++undergroundPoints;
        }
        return (double)undergroundPoints < (double)points * 0.65;
    }
}

