/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.config;

import com.google.gson.GsonBuilder;
import dev.imb11.fog.client.FogClient;
import dev.imb11.fog.client.FogManager;
import dev.imb11.fog.client.util.FogConfigHelper;
import dev.imb11.mru.yacl.EntryType;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.awt.Color;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class FogConfig {
    private static final String CONFIG_FILE_NAME = "config";
    private static final String CONFIG_FILE_EXTENSION = "json";
    private static final ConfigClassHandler<FogConfig> HANDLER = ConfigClassHandler.createBuilder(FogConfig.class).id(ResourceLocation.fromNamespaceAndPath((String)"fog", (String)"config")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(FogClient.getConfigPath(CONFIG_FILE_NAME, CONFIG_FILE_EXTENSION)).appendGsonBuilder(GsonBuilder::setPrettyPrinting).build()).build();
    private static final FogConfigHelper HELPER = new FogConfigHelper("fog", "config");
    @SerialEntry
    public boolean enableMod = true;
    @SerialEntry
    @NotNull
    public List<String> disabledBiomes = List.of("minecraft:nether_wastes", "minecraft:crimson_forest", "minecraft:warped_forest", "minecraft:soul_sand_valley", "minecraft:basalt_deltas");
    @SerialEntry
    public float rainFogMultiplier = 0.9f;
    @SerialEntry
    public float undergroundFogMultiplier = 0.5f;
    @SerialEntry
    public boolean enableBiomeSpecificFogColors = true;
    @SerialEntry
    public boolean enableCloudWhitening = false;
    @SerialEntry
    public float initialFogStart = 0.1f;
    @SerialEntry
    public float initialFogEnd = 0.85f;
    @SerialEntry
    public float raininessTransitionSpeed = 0.005f;
    @SerialEntry
    public float undergroundnessTransitionSpeed = 0.005f;
    @SerialEntry
    public float fogStartTransitionSpeed = 0.005f;
    @SerialEntry
    public float fogEndTransitionSpeed = 0.005f;
    @SerialEntry
    public float darknessTransitionSpeed = 0.005f;
    @SerialEntry
    public float fogColorTransitionSpeed = 0.025f;
    @SerialEntry
    public float startMultiplierTransitionSpeed = 0.0075f;
    @SerialEntry
    public float endMultiplierTransitionSpeed = 0.0075f;
    @SerialEntry
    public boolean enableMoonFogColorInfluence = true;
    @SerialEntry
    public Color newMoonColor = new Color(0, 0, 0, 255);
    @SerialEntry
    public boolean enableSunFogColorInfluence = true;
    @SerialEntry
    public boolean enableHighAltitudeFogColorInfluence = true;
    @SerialEntry
    public boolean prioritizePolytoneFogDefinitions = true;
    @SerialEntry
    public boolean disableModWhenIrisShaderPackIsEnabled = true;

    @NotNull
    public static FogConfig getInstance() {
        return (FogConfig)HANDLER.instance();
    }

    public static void load() {
        HANDLER.load();
    }

    public static void save() {
        HANDLER.save();
    }

    @NotNull
    public YetAnotherConfigLib getYetAnotherConfigLibInstance() {
        return YetAnotherConfigLib.create(HANDLER, (defaults, config, builder) -> builder.title((Component)Component.empty()).save(() -> {
            HANDLER.save();
            FogManager.INSTANCE = new FogManager();
        }).category(ConfigCategory.createBuilder().name(HELPER.getText(EntryType.CATEGORY_NAME, "general")).option(Option.createBuilder().name(HELPER.getText(EntryType.OPTION_NAME, "enable_mod")).description(unused -> OptionDescription.createBuilder().text(new Component[]{HELPER.getText(EntryType.OPTION_DESCRIPTION, "enable_mod")}).build()).binding((Object)defaults.enableMod, () -> this.enableMod, newEnableMod -> {
            this.enableMod = newEnableMod;
        }).controller(BooleanControllerBuilder::create).build()).option((Option)ButtonOption.createBuilder().name(HELPER.getText(EntryType.OPTION_NAME, "reset_fog_modifications")).description(OptionDescription.of((Component[])new Component[]{HELPER.getText(EntryType.OPTION_DESCRIPTION, "reset_fog_modifications")})).action((yaclScreen, buttonOption) -> {
            FogConfig.load();
            FogManager.INSTANCE = new FogManager();
        }).build()).option((Option)LabelOption.createBuilder().line((Component)Component.literal((String)"")).build()).option(HELPER.get("enable_biome_specific_fog_colors", defaults.enableBiomeSpecificFogColors, () -> config.enableBiomeSpecificFogColors, val -> {
            config.enableBiomeSpecificFogColors = val;
        })).option(HELPER.get("enable_high_altitude_fog_color_influence", defaults.enableHighAltitudeFogColorInfluence, () -> config.enableHighAltitudeFogColorInfluence, val -> {
            config.enableHighAltitudeFogColorInfluence = val;
        })).option(HELPER.get("enable_sun_fog_color_influence", defaults.enableSunFogColorInfluence, () -> config.enableSunFogColorInfluence, val -> {
            config.enableSunFogColorInfluence = val;
        })).option(HELPER.get("enable_moon_fog_color_influence", defaults.enableMoonFogColorInfluence, () -> config.enableMoonFogColorInfluence, val -> {
            config.enableMoonFogColorInfluence = val;
        })).option(HELPER.get("new_moon_color", defaults.newMoonColor, () -> config.newMoonColor, val -> {
            config.newMoonColor = val;
        })).option(Option.createBuilder().name(HELPER.getText(EntryType.OPTION_NAME, "enable_cloud_whitening")).description(unused -> OptionDescription.createBuilder().text(new Component[]{HELPER.getText(EntryType.OPTION_DESCRIPTION, "enable_cloud_whitening")}).build()).binding((Object)defaults.enableCloudWhitening, () -> this.enableCloudWhitening, newDisableCloudWhitening -> {
            this.enableCloudWhitening = newDisableCloudWhitening;
        }).controller(option -> BooleanControllerBuilder.create((Option)option).coloured(true).trueFalseFormatter()).available(!FogClient.isModInstalled("sodium")).build()).option((Option)LabelOption.createBuilder().line((Component)Component.literal((String)"")).build()).option(HELPER.getSlider("rain_fog_multiplier", 0.0f, 1.0f, 0.05f, defaults.rainFogMultiplier, () -> Float.valueOf(config.rainFogMultiplier), val -> {
            config.rainFogMultiplier = val.floatValue();
        })).option(HELPER.getSlider("underground_fog_multiplier", 0.0f, 1.0f, 0.05f, defaults.undergroundFogMultiplier, () -> Float.valueOf(config.undergroundFogMultiplier), val -> {
            config.undergroundFogMultiplier = val.floatValue();
        })).option((Option)LabelOption.createBuilder().line((Component)Component.literal((String)"")).build()).group((OptionGroup)ListOption.createBuilder().name((Component)Component.translatable((String)String.format("%s.config.option.disabled_biomes", "fog"))).binding(defaults.disabledBiomes, () -> this.disabledBiomes, val -> {
            this.disabledBiomes = val;
        }).controller(StringControllerBuilder::create).initial((Object)"mod_id:dimension_id").collapsed(true).build()).group(OptionGroup.createBuilder().name((Component)Component.translatable((String)String.format("%s.config.group.initial_values", "fog"))).option(HELPER.getSlider("initial_fog_start", 0.0f, 1.0f, 0.05f, defaults.initialFogStart, () -> Float.valueOf(config.initialFogStart), val -> {
            config.initialFogStart = val.floatValue();
        })).option(HELPER.getSlider("initial_fog_end", 0.0f, 1.0f, 0.05f, defaults.initialFogEnd, () -> Float.valueOf(config.initialFogEnd), val -> {
            config.initialFogEnd = val.floatValue();
        })).collapsed(true).build()).build()).category(ConfigCategory.createBuilder().name(HELPER.getText(EntryType.CATEGORY_NAME, "transition_speeds")).option(HELPER.getFieldTDP("fog_start_transition_speed", 0.001f, 0.5f, defaults.fogStartTransitionSpeed, () -> Float.valueOf(config.fogStartTransitionSpeed), val -> {
            config.fogStartTransitionSpeed = val.floatValue();
        })).option(HELPER.getFieldTDP("fog_end_transition_speed", 0.001f, 0.5f, defaults.fogEndTransitionSpeed, () -> Float.valueOf(config.fogEndTransitionSpeed), val -> {
            config.fogEndTransitionSpeed = val.floatValue();
        })).option(HELPER.getFieldTDP("fog_color_transition_speed", 0.001f, 0.5f, defaults.fogColorTransitionSpeed, () -> Float.valueOf(config.fogColorTransitionSpeed), val -> {
            config.fogColorTransitionSpeed = val.floatValue();
        })).option((Option)LabelOption.createBuilder().line((Component)Component.literal((String)"")).build()).option(HELPER.getFieldTDP("raininess_transition_speed", 0.001f, 0.5f, defaults.raininessTransitionSpeed, () -> Float.valueOf(config.raininessTransitionSpeed), val -> {
            config.raininessTransitionSpeed = val.floatValue();
        })).option(HELPER.getFieldTDP("undergroundness_transition_speed", 0.001f, 0.5f, defaults.undergroundnessTransitionSpeed, () -> Float.valueOf(config.undergroundnessTransitionSpeed), val -> {
            config.undergroundnessTransitionSpeed = val.floatValue();
        })).option(HELPER.getFieldTDP("darkness_transition_speed", 0.001f, 0.5f, defaults.darknessTransitionSpeed, () -> Float.valueOf(config.darknessTransitionSpeed), val -> {
            config.darknessTransitionSpeed = val.floatValue();
        })).option((Option)LabelOption.createBuilder().line((Component)Component.literal((String)"")).build()).group(OptionGroup.createBuilder().name((Component)Component.translatable((String)String.format("%s.config.group.multipliers", "fog"))).option(HELPER.getFieldTDP("start_multiplier_transition_speed", 0.001f, 0.5f, defaults.startMultiplierTransitionSpeed, () -> Float.valueOf(config.startMultiplierTransitionSpeed), val -> {
            config.startMultiplierTransitionSpeed = val.floatValue();
        })).option(HELPER.getFieldTDP("end_multiplier_transition_speed", 0.001f, 0.5f, defaults.endMultiplierTransitionSpeed, () -> Float.valueOf(config.endMultiplierTransitionSpeed), val -> {
            config.endMultiplierTransitionSpeed = val.floatValue();
        })).collapsed(true).build()).build()).category(ConfigCategory.createBuilder().name(HELPER.getText(EntryType.CATEGORY_NAME, "compatibility")).option(Option.createBuilder().name(HELPER.getText(EntryType.OPTION_NAME, "disable_mod_when_iris_shader_pack_is_enabled")).description(unused -> OptionDescription.createBuilder().text(new Component[]{HELPER.getText(EntryType.OPTION_DESCRIPTION, "disable_mod_when_iris_shader_pack_is_enabled")}).build()).binding((Object)defaults.disableModWhenIrisShaderPackIsEnabled, () -> this.disableModWhenIrisShaderPackIsEnabled, newDisableModWhenIrisShaderPackIsEnabled -> {
            this.disableModWhenIrisShaderPackIsEnabled = newDisableModWhenIrisShaderPackIsEnabled;
        }).controller(option -> BooleanControllerBuilder.create((Option)option).coloured(true).trueFalseFormatter()).available(FogClient.isModInstalled("iris")).build()).option(Option.createBuilder().name(HELPER.getText(EntryType.OPTION_NAME, "prioritize_polytone_fog_definitions")).description(unused -> OptionDescription.createBuilder().text(new Component[]{HELPER.getText(EntryType.OPTION_DESCRIPTION, "prioritize_polytone_fog_definitions")}).build()).binding((Object)defaults.prioritizePolytoneFogDefinitions, () -> this.prioritizePolytoneFogDefinitions, newPrioritizePolytoneFogDefinitions -> {
            this.prioritizePolytoneFogDefinitions = newPrioritizePolytoneFogDefinitions;
        }).controller(option -> BooleanControllerBuilder.create((Option)option).coloured(true).trueFalseFormatter()).available(FogClient.isModInstalled("polytone")).build()).build()));
    }
}

