/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.mixin.client.rendering;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.imb11.fog.client.FogManager;
import dev.imb11.fog.client.compat.polytone.IrisCompat;
import dev.imb11.fog.client.util.math.EnvironmentCalculations;
import dev.imb11.fog.config.FogConfig;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.world.level.material.FogType;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FogRenderer.class})
public abstract class BackgroundRendererMixin {
    @Shadow
    private static float fogRed;
    @Shadow
    private static float fogGreen;
    @Shadow
    private static float fogBlue;

    @Inject(method={"setupColor(Lnet/minecraft/client/Camera;FLnet/minecraft/client/multiplayer/ClientLevel;IF)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;clearColor(FFFF)V", remap=false, shift=At.Shift.BEFORE)})
    private static void fog$modifyFogColors(@NotNull Camera camera, float tickDelta, @NotNull ClientLevel world, int viewDistance, float skyDarkness, @NotNull CallbackInfo ci) {
        if (!FogConfig.getInstance().enableMod || FogManager.isInDisabledBiome() || camera.getFluidInCamera() != FogType.NONE || IrisCompat.shouldDisableMod()) {
            return;
        }
        FogManager fogManager = FogManager.getInstance();
        FogManager.FogSettings fogSettings = fogManager.getFogSettings(tickDelta, viewDistance);
        if (!world.dimensionType().hasFixedTime() || !(world.effects() instanceof DimensionSpecialEffects.EndEffects)) {
            fogSettings = EnvironmentCalculations.apply(fogManager.getUndergroundFactor(Minecraft.getInstance(), tickDelta), fogSettings, tickDelta);
        }
        fogRed = fogSettings.fogRed();
        fogGreen = fogSettings.fogGreen();
        fogBlue = fogSettings.fogBlue();
    }

    @Inject(method={"setupFog(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/FogRenderer$FogMode;FZF)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderFogStart(F)V", remap=false, shift=At.Shift.BEFORE)})
    private static void fog$fogRenderEvent(@NotNull Camera camera, @NotNull FogRenderer.FogMode fogType, float viewDistance, boolean thickFog, float deltaTick, @NotNull CallbackInfo ci, @Local @NotNull FogRenderer.FogData fogData) {
        ClientLevel clientWorld = Minecraft.getInstance().level;
        if (clientWorld == null || !FogConfig.getInstance().enableMod || FogManager.isInDisabledBiome() || camera.getFluidInCamera() != FogType.NONE || IrisCompat.shouldDisableMod()) {
            return;
        }
        FogManager.FogSettings fogSettings = FogManager.getInstance().getFogSettings(deltaTick, viewDistance);
        fogData.start = (float)fogSettings.fogStart();
        fogData.end = (float)fogSettings.fogEnd();
        fogData.shape = FogShape.SPHERE;
    }

    @WrapWithCondition(method={"setupColor(Lnet/minecraft/client/Camera;FLnet/minecraft/client/multiplayer/ClientLevel;IF)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;clearColor(FFFF)V")})
    private static boolean fog$setFogBlackChangeClearColor(float red, float green, float blue, float alpha) {
        if (!FogConfig.getInstance().enableMod) {
            return true;
        }
        Minecraft client = Minecraft.getInstance();
        ClientLevel clientWorld = client.level;
        Camera camera = client.gameRenderer.getMainCamera();
        if (clientWorld == null || camera == null || FogManager.isInDisabledBiome() || camera.getFluidInCamera() != FogType.NONE || IrisCompat.shouldDisableMod()) {
            return true;
        }
        float tickDelta = client.getTimer().getGameTimeDeltaPartialTick(true);
        FogManager fogManager = FogManager.getInstance();
        FogManager.FogSettings fogSettings = fogManager.getFogSettings(tickDelta, ((Integer)client.options.renderDistance().get()).intValue());
        if (!clientWorld.dimensionType().hasFixedTime() || !(clientWorld.effects() instanceof DimensionSpecialEffects.EndEffects)) {
            fogSettings = EnvironmentCalculations.apply(fogManager.getUndergroundFactor(client, tickDelta), fogSettings, tickDelta);
        }
        RenderSystem.clearColor((float)fogSettings.fogRed(), (float)fogSettings.fogGreen(), (float)fogSettings.fogBlue(), (float)1.0f);
        return false;
    }
}

