/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.mixin.client.rendering;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.imb11.fog.client.FogManager;
import dev.imb11.fog.client.compat.polytone.IrisCompat;
import dev.imb11.fog.client.util.math.CloudCalculator;
import dev.imb11.fog.config.FogConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class WorldRendererMixin {
    @Shadow
    @Nullable
    private ClientLevel level;

    @WrapOperation(method={"renderClouds(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FDDD)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getCloudColor(F)Lnet/minecraft/world/phys/Vec3;")})
    @NotNull
    public Vec3 fog$whiteClouds(ClientLevel instance, float tickDelta, @NotNull Operation<Vec3> original) {
        if (this.level == null || !FogConfig.getInstance().enableMod || !(this.level.effects() instanceof DimensionSpecialEffects.OverworldEffects) || !FogConfig.getInstance().enableCloudWhitening || FogManager.isInDisabledBiome() || this.level.dimensionType().hasFixedTime() || IrisCompat.shouldDisableMod()) {
            return (Vec3)original.call(new Object[]{this.level, Float.valueOf(tickDelta)});
        }
        float color = CloudCalculator.getCloudColor(this.level.getDayTime() % 24000L);
        return new Vec3((double)color, (double)color, (double)color);
    }

    @WrapOperation(method={"renderClouds(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FDDD)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/FogRenderer;levelFogColor()V")})
    public void fog$removeFogFromClouds(@NotNull Operation<Void> original, @Local(argsOnly=true) float tickDelta) {
        if (this.level == null || !FogConfig.getInstance().enableMod || !(this.level.effects() instanceof DimensionSpecialEffects.OverworldEffects) || !FogConfig.getInstance().enableCloudWhitening || FogManager.isInDisabledBiome() || this.level.dimensionType().hasFixedTime() || IrisCompat.shouldDisableMod()) {
            original.call(new Object[0]);
            return;
        }
        RenderSystem.setShaderFogStart((float)10000.0f);
        Vec3 cloudsColor = this.level.getCloudColor(tickDelta);
        RenderSystem.setShaderFogColor((float)((float)cloudsColor.x()), (float)((float)cloudsColor.y()), (float)((float)cloudsColor.z()));
    }

    @Inject(method={"renderClouds(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FDDD)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/VertexBuffer;drawWithShader(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lnet/minecraft/client/renderer/ShaderInstance;)V", shift=At.Shift.BEFORE)})
    public void fog$whiteCloudsDisableFog(PoseStack matrices, Matrix4f matrix4f, Matrix4f matrix4f2, float tickDelta, double cameraX, double cameraY, double cameraZ, CallbackInfo ci) {
        if (this.level == null || !FogConfig.getInstance().enableMod || !(this.level.effects() instanceof DimensionSpecialEffects.OverworldEffects) || !FogConfig.getInstance().enableCloudWhitening || FogManager.isInDisabledBiome() || this.level.dimensionType().hasFixedTime() || IrisCompat.shouldDisableMod()) {
            return;
        }
        RenderSystem.setShaderFogStart((float)((Integer)Minecraft.getInstance().options.renderDistance().get()).intValue());
    }
}

