/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.imb11.fog.client.util.TickUtil;
import dev.imb11.fog.client.util.color.Color;
import java.util.HashMap;
import net.minecraft.class_1959;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5294;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FogColors {
    private static final HashMap<Class<? extends class_5294>, FogColors> CACHED_DEFAULTS = new HashMap();
    public static final FogColors DEFAULT_CAVE = new FogColors("#212121", "#101010");
    public static final Codec<FogColors> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("day").forGetter(FogColors::getDay), (App)Codec.STRING.fieldOf("night").forGetter(FogColors::getNight)).apply((Applicative)instance, FogColors::new));
    @NotNull
    private final String day;
    @NotNull
    private final String night;
    @Nullable
    private transient Color dayCached;
    @Nullable
    private transient Color nightCached;

    @NotNull
    public static FogColors getDefault(@Nullable class_638 world) {
        if (world == null) {
            return new FogColors("#b9d2fd", "#000000");
        }
        class_5294 worldDimensionEffects = world.method_28103();
        if (CACHED_DEFAULTS.containsKey(worldDimensionEffects.getClass())) {
            return CACHED_DEFAULTS.get(worldDimensionEffects.getClass());
        }
        if (worldDimensionEffects instanceof class_5294.class_5297) {
            FogColors fogColors = new FogColors("#b9d2fd", "#000000");
            CACHED_DEFAULTS.put(worldDimensionEffects.getClass(), fogColors);
            return fogColors;
        }
        class_310 client = class_310.method_1551();
        float sunHeight = class_3532.method_15363((float)(class_3532.method_15362((float)(world.method_30274(TickUtil.getTickDelta()) * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
        class_243 daySkyColor = worldDimensionEffects.method_28112(class_243.method_24457((int)((class_1959)world.method_22385().method_24938(client.field_1724.method_23317(), client.field_1724.method_23318(), client.field_1724.method_23321()).comp_349()).method_24376()), sunHeight);
        class_243 nightSkyColor = daySkyColor.method_1021(0.2);
        FogColors fogColors = new FogColors(Color.from(daySkyColor).asHex(), Color.from(nightSkyColor).asHex());
        CACHED_DEFAULTS.put(worldDimensionEffects.getClass(), fogColors);
        return fogColors;
    }

    public FogColors(@NotNull String day, @NotNull String night) {
        assert (day.matches("^#[0-9a-fA-F]{6}$")) : "Invalid day color format: " + day;
        assert (night.matches("^#[0-9a-fA-F]{6}$")) : "Invalid night color format: " + night;
        this.day = day;
        this.night = night;
    }

    public Color getDayColor() {
        if (this.dayCached == null) {
            this.dayCached = Color.parse(this.day);
        }
        return this.dayCached;
    }

    public Color getNightColor() {
        if (this.nightCached == null) {
            this.nightCached = Color.parse(this.night);
        }
        return this.nightCached;
    }

    @NotNull
    private String getDay() {
        return this.day;
    }

    @NotNull
    private String getNight() {
        return this.night;
    }

    public static class Builder {
        @NotNull
        private String day = FogColors.getDefault(null).getDay();
        @NotNull
        private String night = FogColors.getDefault(null).getNight();

        @NotNull
        public Builder day(@NotNull String day) {
            this.day = day;
            return this;
        }

        @NotNull
        public Builder night(@NotNull String night) {
            this.night = night;
            return this;
        }

        @NotNull
        public FogColors build() {
            return new FogColors(this.day, this.night);
        }
    }
}

