/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.client.compat.polytone;

import dev.imb11.fog.api.FogColors;
import dev.imb11.fog.config.FogConfig;
import dev.imb11.fog.mixin.compat.BiomeEffectsManagerAccessor;
import dev.imb11.mru.LoaderUtils;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.biome.BiomeEffectModifier;
import net.minecraft.class_1959;
import net.minecraft.class_5321;

public class PolytoneCompat {
    private static final Map<String, Integer> darkenCache = new HashMap<String, Integer>();

    public static boolean shouldUsePolytone() {
        return LoaderUtils.isModInstalled((String)"polytone") && FogConfig.getInstance().prioritizePolytoneFogDefinitions;
    }

    private static int darkenColor(int colorInt, double factor) {
        if (factor < 0.0 || factor > 1.0) {
            throw new IllegalArgumentException("Darkening factor must be between 0 and 1.");
        }
        String key = colorInt + "-" + factor;
        if (darkenCache.containsKey(key)) {
            return darkenCache.get(key);
        }
        int red = colorInt >> 16 & 0xFF;
        int green = colorInt >> 8 & 0xFF;
        int blue = colorInt & 0xFF;
        red = Math.max(0, (int)((double)red * (1.0 - factor)));
        green = Math.max(0, (int)((double)green * (1.0 - factor)));
        blue = Math.max(0, (int)((double)blue * (1.0 - factor)));
        int darkenedColor = red << 16 | green << 8 | blue;
        darkenCache.put(key, darkenedColor);
        return darkenedColor;
    }

    private static String intToRgbHex(int colorInt) {
        return String.format("#%06X", colorInt);
    }

    public static FogColors getFogColorsFromPolytone(class_5321<class_1959> biome, FogColors defaultColors) {
        BiomeEffectModifier effects = ((BiomeEffectsManagerAccessor)Polytone.BIOME_MODIFIERS).getEffectsToApply().get(biome);
        if (effects == null) {
            return defaultColors;
        }
        if (effects.fogColor().isEmpty()) {
            return defaultColors;
        }
        int dayColor = (Integer)effects.fogColor().get();
        int nightColor = PolytoneCompat.darkenColor(dayColor, 0.3);
        return new FogColors(PolytoneCompat.intToRgbHex(dayColor), PolytoneCompat.intToRgbHex(nightColor));
    }
}

