/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.client.registry;

import dev.imb11.fog.api.CustomFogDefinition;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class FogRegistry {
    private static final Map<class_6862<class_3195>, CustomFogDefinition> STRUCTURE_TAG_FOG_REGISTRY = new ConcurrentHashMap<class_6862<class_3195>, CustomFogDefinition>();
    private static final Map<class_2960, CustomFogDefinition> STRUCTURE_FOG_REGISTRY = new ConcurrentHashMap<class_2960, CustomFogDefinition>();
    private static final Map<class_6862<class_1959>, CustomFogDefinition> BIOME_TAG_FOG_REGISTRY = new ConcurrentHashMap<class_6862<class_1959>, CustomFogDefinition>();
    private static final Map<class_2960, CustomFogDefinition> BIOME_FOG_REGISTRY = new ConcurrentHashMap<class_2960, CustomFogDefinition>();
    private static final Map<class_2960, class_2960> TAGGED_BIOME_TO_FOG_CACHE = new ConcurrentHashMap<class_2960, class_2960>();
    private static final Map<class_2960, Set<class_2960>> TAGGED_BIOME_SKIP_LIST = new ConcurrentHashMap<class_2960, Set<class_2960>>();

    @NotNull
    public static Map<class_6862<class_3195>, CustomFogDefinition> getStructureTagFogRegistry() {
        return STRUCTURE_TAG_FOG_REGISTRY;
    }

    @NotNull
    public static Map<class_2960, CustomFogDefinition> getStructureFogRegistry() {
        return STRUCTURE_FOG_REGISTRY;
    }

    @NotNull
    public static Map<class_6862<class_1959>, CustomFogDefinition> getBiomeTagFogRegistry() {
        return BIOME_TAG_FOG_REGISTRY;
    }

    @NotNull
    public static Map<class_2960, CustomFogDefinition> getBiomeFogRegistry() {
        return BIOME_FOG_REGISTRY;
    }

    @NotNull
    public static CustomFogDefinition getFogDefinitionOrDefault(@NotNull class_2960 biomeId, @NotNull class_638 world) {
        CustomFogDefinition biomeFogDefinition = FogRegistry.getBiomeFogRegistry().get(biomeId);
        if (biomeFogDefinition != null) {
            return biomeFogDefinition;
        }
        class_2960 cachedFogId = TAGGED_BIOME_TO_FOG_CACHE.get(biomeId);
        if (cachedFogId != null) {
            return FogRegistry.getBiomeTagFogRegistry().get(class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)cachedFogId));
        }
        Set skippedTags = TAGGED_BIOME_SKIP_LIST.getOrDefault(biomeId, new HashSet());
        class_2378 biomeRegistry = world.method_30349().method_30530(class_7924.field_41236);
        for (Map.Entry<class_6862<class_1959>, CustomFogDefinition> biomeTagFogEntry : FogRegistry.getBiomeTagFogRegistry().entrySet()) {
            Optional entryListOptional;
            class_6862<class_1959> tagKey = biomeTagFogEntry.getKey();
            class_2960 tagId = tagKey.comp_327();
            if (skippedTags.contains(tagId) || !(entryListOptional = biomeRegistry.method_46733(tagKey)).isPresent()) continue;
            class_6885.class_6888 entryList = (class_6885.class_6888)entryListOptional.get();
            for (class_6880 entry : entryList) {
                if (!((class_5321)entry.method_40230().get()).method_29177().equals((Object)biomeId)) continue;
                TAGGED_BIOME_TO_FOG_CACHE.put(biomeId, tagId);
                TAGGED_BIOME_SKIP_LIST.put(biomeId, skippedTags);
                return biomeTagFogEntry.getValue();
            }
            skippedTags.add(tagId);
        }
        TAGGED_BIOME_SKIP_LIST.put(biomeId, skippedTags);
        return CustomFogDefinition.getDefault(world);
    }

    public static void resetCaches() {
        TAGGED_BIOME_TO_FOG_CACHE.clear();
        TAGGED_BIOME_SKIP_LIST.clear();
    }
}

