/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.client.resource;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.imb11.fog.api.CustomFogDefinition;
import dev.imb11.fog.client.FogClient;
import dev.imb11.fog.client.registry.FogRegistry;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FogResourceReloader
extends class_4080<Void> {
    @NotNull
    public static final class_2960 IDENTIFIER = class_2960.method_60655((String)"fog", (String)"resource_reloader");
    @NotNull
    private static final String TAG_FOLDER_NAME = "tag";
    @NotNull
    public static final String FOG_DEFINITIONS_FOLDER_NAME = "fog_definitions";
    @NotNull
    public static final String STRUCTURE_FOLDER_NAME = "structure";
    @NotNull
    public static final String STRUCTURE_TAGS_FOLDER_NAME = String.format("%s/%s", "tag", "structure");
    @NotNull
    public static final String BIOME_FOLDER_NAME = "biome";
    @NotNull
    public static final String BIOME_TAGS_FOLDER_NAME = String.format("%s/%s", "tag", "biome");
    @NotNull
    private static final Gson GSON = new Gson();
    @NotNull
    private static final String JSON_FILE_SUFFIX = ".json";

    @Nullable
    protected Void prepare(class_3300 resourceManager, class_3695 profiler) {
        FogRegistry.resetCaches();
        this.loadTaggedFogs(resourceManager, STRUCTURE_TAGS_FOLDER_NAME, FogRegistry.getStructureTagFogRegistry(), class_7924.field_41246);
        this.loadTaggedFogs(resourceManager, BIOME_TAGS_FOLDER_NAME, FogRegistry.getBiomeTagFogRegistry(), class_7924.field_41236);
        this.loadFogs(resourceManager, STRUCTURE_FOLDER_NAME, FogRegistry.getStructureFogRegistry());
        this.loadFogs(resourceManager, BIOME_FOLDER_NAME, FogRegistry.getBiomeFogRegistry());
        return null;
    }

    protected void apply(@Nullable Void prepared, class_3300 resourceManager, class_3695 profiler) {
    }

    private <K> void loadFogs(@NotNull class_3300 resourceManager, @NotNull String folderName, @NotNull Map<K, CustomFogDefinition> fogRegistry, @NotNull Function<String, K> keyGenerator) {
        fogRegistry.clear();
        Map jsonFogs = resourceManager.method_14488(String.format("%s/%s", FOG_DEFINITIONS_FOLDER_NAME, folderName), identifier -> identifier.toString().endsWith(JSON_FILE_SUFFIX));
        for (Map.Entry jsonFog : jsonFogs.entrySet()) {
            class_2960 jsonFogPath = (class_2960)jsonFog.getKey();
            String[] jsonFogPathSplit = jsonFogPath.method_12832().replace(JSON_FILE_SUFFIX, "").split("/");
            class_2960 fogIdentifier = class_2960.method_60655((String)jsonFogPath.method_12836(), (String)jsonFogPathSplit[jsonFogPathSplit.length - 1]);
            K fogKey = keyGenerator.apply(fogIdentifier.toString());
            if (fogRegistry.containsKey(fogKey)) continue;
            try {
                fogRegistry.put(fogKey, (CustomFogDefinition)CustomFogDefinition.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)GSON.fromJson(new String(((class_3298)jsonFog.getValue()).method_14482().readAllBytes()), JsonElement.class))).result().orElseThrow());
            }
            catch (IOException e) {
                FogClient.LOGGER.error("Exception thrown while deserializing a fog definition (identifier: {}): {}", (Object)fogIdentifier, (Object)e);
            }
        }
    }

    private <T> void loadTaggedFogs(@NotNull class_3300 resourceManager, @NotNull String folderName, @NotNull Map<class_6862<T>, CustomFogDefinition> fogRegistry, class_5321<? extends class_2378<T>> registryKey) {
        this.loadFogs(resourceManager, folderName, fogRegistry, identifier -> class_6862.method_40092((class_5321)registryKey, (class_2960)class_2960.method_12829((String)identifier)));
    }

    private void loadFogs(@NotNull class_3300 resourceManager, @NotNull String folderName, @NotNull Map<class_2960, CustomFogDefinition> fogRegistry) {
        this.loadFogs(resourceManager, folderName, fogRegistry, class_2960::method_12829);
    }
}

