/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.client.util.math;

import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public record DarknessCalculation(float fogStart, float fogEnd, float darknessValue) {
    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static DarknessCalculation of(@NotNull class_310 client, float fogStart, float fogEnd, float deltaTick) {
        class_1293 effect;
        float renderDistance = client.field_1773.method_3193();
        class_1297 entity = client.method_1560();
        float darknessValue = 0.0f;
        if (!(entity instanceof class_1309)) {
            return new DarknessCalculation(fogStart, fogEnd, darknessValue);
        }
        class_1309 livingEntity = (class_1309)entity;
        if (livingEntity.method_6059(class_1294.field_5919)) {
            fogStart = 64.0f / renderDistance;
            fogEnd = 128.0f / renderDistance;
            darknessValue = 1.0f;
        } else if (livingEntity.method_6059(class_1294.field_38092) && (effect = livingEntity.method_6112(class_1294.field_38092)) != null) {
            float factor = ((Double)client.field_1690.method_42472().method_41753()).floatValue();
            float intensity = effect.method_55653(livingEntity, deltaTick) * factor;
            float darknessScale = DarknessCalculation.calculateDarknessScale(livingEntity, deltaTick);
            fogStart = 128.0f / renderDistance * (1.0f - darknessScale);
            fogEnd = 240.0f / renderDistance;
            darknessValue = intensity;
        }
        return new DarknessCalculation(fogStart, fogEnd, darknessValue);
    }

    private static float calculateDarknessScale(@NotNull class_1309 entity, float deltaTick) {
        float darknessFactor = entity.method_6112(class_1294.field_38092).method_55653(entity, deltaTick);
        float factor = 0.45f * darknessFactor;
        return Math.max(0.0f, class_3532.method_15362((float)(((float)entity.field_6012 - deltaTick) * (float)Math.PI * 0.025f)) * factor);
    }
}

