/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.carved_wood.common.block.custom;

import net.im_maker.carved_wood.common.block.entity.CWBlockEntities;
import net.im_maker.carved_wood.common.block.entity.custom.CWBeehiveBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CWBeehiveBlock
extends BeehiveBlock {
    private final Boolean isFlammable;

    public CWBeehiveBlock(BlockBehaviour.Properties pProperties, Boolean isFlammable) {
        super(pProperties);
        this.isFlammable = isFlammable;
    }

    public CWBeehiveBlock(BlockBehaviour.Properties pProperties) {
        this(pProperties, true);
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.isFlammable != false ? 20 : super.getFlammability(state, level, pos, direction);
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.isFlammable != false ? 5 : super.getFlammability(state, level, pos, direction);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.isClientSide ? null : CWBeehiveBlock.createTickerHelper(type, CWBlockEntities.BEEHIVE.get(), BeehiveBlockEntity::serverTick);
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new CWBeehiveBlockEntity(blockPos, blockState);
    }
}

