/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.carved_wood.common.block.custom;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.im_maker.carved_wood.common.block.block_values.CWBlockStateProperties;
import net.im_maker.carved_wood.common.block.block_values.WoodenLanternShape;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WoodenLantern
extends Block
implements SimpleWaterloggedBlock {
    public static final MapCodec<WoodenLantern> CODEC = WoodenLantern.simpleCodec(WoodenLantern::new);
    public static final BooleanProperty HANGING = BlockStateProperties.HANGING;
    public static final EnumProperty<WoodenLanternShape> SHAPE = CWBlockStateProperties.WOODEN_LANTERN_SHAPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape AABB = Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    protected static final VoxelShape AA = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0);
    protected static final VoxelShape BB = Block.box((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);
    protected static final VoxelShape AB = Block.box((double)6.0, (double)14.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    protected static final VoxelShape UNHANGING_SHAPE = Shapes.or((VoxelShape)AABB, (VoxelShape[])new VoxelShape[]{AA, BB});
    protected static final VoxelShape HANGING_SHAPE = Shapes.or((VoxelShape)AABB, (VoxelShape[])new VoxelShape[]{AA, BB, AB});

    public MapCodec<WoodenLantern> codec() {
        return CODEC;
    }

    public WoodenLantern(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HANGING, (Comparable)Boolean.valueOf(false))).setValue(SHAPE, (Comparable)((Object)WoodenLanternShape.SETTING))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        FluidState fluidstate = blockPlaceContext.getLevel().getFluidState(blockPlaceContext.getClickedPos());
        for (Direction direction : blockPlaceContext.getNearestLookingDirections()) {
            BlockState blockstate;
            if (direction.getAxis() != Direction.Axis.Y || !(blockstate = (BlockState)this.defaultBlockState().setValue((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).canSurvive((LevelReader)blockPlaceContext.getLevel(), blockPlaceContext.getClickedPos())) continue;
            return (BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        }
        return null;
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return (Boolean)blockState.getValue((Property)HANGING) != false ? HANGING_SHAPE : UNHANGING_SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockBlockStateBuilder) {
        blockBlockStateBuilder.add(new Property[]{HANGING, SHAPE, WATERLOGGED});
    }

    protected boolean canSurvive(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        Direction direction = WoodenLantern.getConnectedDirection(blockState).getOpposite();
        return Block.canSupportCenter((LevelReader)levelReader, (BlockPos)blockPos.relative(direction), (Direction)direction.getOpposite());
    }

    protected static Direction getConnectedDirection(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    protected BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(blockPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        return WoodenLantern.getConnectedDirection(blockState).getOpposite() == direction && !blockState.canSurvive((LevelReader)levelAccessor, blockPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(blockState, direction, blockState1, levelAccessor, blockPos, blockPos1);
    }

    protected FluidState getFluidState(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(blockState);
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }
}

