/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.carved_wood.common.recipe.custom;

import net.im_maker.carved_wood.common.recipe.CWRecipes;
import net.im_maker.carved_wood.common.util.CWTags;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BookshelfRecipe
extends CustomRecipe {
    public BookshelfRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        if (craftingInput.width() != 3 || craftingInput.height() != 3) {
            return false;
        }
        ItemStack[][] pattern = new ItemStack[3][3];
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                pattern[y][x] = craftingInput.getItem(x + y * 3);
            }
        }
        return this.isPlanks(pattern[0][0]) && this.isPlanks(pattern[0][1]) && this.isPlanks(pattern[0][2]) && this.isBook(pattern[1][0]) && this.isBook(pattern[1][1]) && this.isBook(pattern[1][2]) && this.isPlanks(pattern[2][0]) && this.isPlanks(pattern[2][1]) && this.isPlanks(pattern[2][2]);
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        return new ItemStack((ItemLike)Items.BOOKSHELF);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public RecipeSerializer<?> getSerializer() {
        return CWRecipes.BOOKSHELF.get();
    }

    private boolean isBook(ItemStack stack) {
        return stack.is(Items.BOOK);
    }

    private boolean isPlanks(ItemStack stack) {
        return stack.is(ItemTags.PLANKS) && !stack.is(CWTags.Items.FLAG) && !BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString().equals("vanillabackport:pale_oak_planks");
    }
}

