/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.carved_wood.mixin;

import net.im_maker.carved_wood.common.util.CWTags;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WrittenBookItem.class})
public abstract class MixinWrittenBookItem {
    @Inject(method={"useOn"}, at={@At(value="HEAD")}, cancellable=true)
    public void onUseOn(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        BlockPos blockPos;
        Level level = context.getLevel();
        BlockState blockState = level.getBlockState(blockPos = context.getClickedPos());
        if (blockState.is(CWTags.Blocks.LECTERNS)) {
            if (LecternBlock.tryPlaceBook((LivingEntity)context.getPlayer(), (Level)level, (BlockPos)blockPos, (BlockState)blockState, (ItemStack)context.getItemInHand())) {
                cir.setReturnValue((Object)InteractionResult.sidedSuccess((boolean)level.isClientSide));
            } else {
                cir.setReturnValue((Object)InteractionResult.PASS);
            }
        } else {
            cir.setReturnValue((Object)InteractionResult.PASS);
        }
    }
}

