/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.carved_wood;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.im_maker.carved_wood.client.renderer.CWModelLayers;
import net.im_maker.carved_wood.client.renderer.block.CWCampfireRenderer;
import net.im_maker.carved_wood.client.renderer.block.CWChestRenderer;
import net.im_maker.carved_wood.common.block.CWBlocks;
import net.im_maker.carved_wood.common.block.entity.CWBlockEntities;
import net.im_maker.carved_wood.common.item.CWItems;
import net.im_maker.carved_wood.common.recipe.CWRecipes;
import net.im_maker.carved_wood.common.util.CWPoiType;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.LecternRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.slf4j.Logger;

@Mod(value="carved_wood")
public class CarvedWood {
    public static final String MOD_ID = "carved_wood";
    public static final List<String> WOOD_TYPES = new ArrayList<String>(Arrays.asList("oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "mangrove", "cherry", "pale_oak", "bamboo", "crimson", "warped"));
    private static final Function<ItemLike, ItemStack> FUNCTION = ItemStack::new;
    public static final Logger LOGGER = LogUtils.getLogger();

    public CarvedWood(IEventBus modEventBus, ModContainer modContainer) {
        CWBlocks.register(modEventBus);
        CWItems.register(modEventBus);
        CWRecipes.register(modEventBus);
        CWBlockEntities.register(modEventBus);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::addCreative);
    }

    private static void addAfter(BuildCreativeModeTabContentsEvent event, ItemLike after, ItemLike ... blocks) {
        for (int i = blocks.length - 1; i >= 0; --i) {
            ItemLike block = blocks[i];
            if (block == Blocks.AIR || after == Blocks.AIR) continue;
            event.insertAfter(FUNCTION.apply(after), FUNCTION.apply(block), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    private static void addBefore(BuildCreativeModeTabContentsEvent event, ItemLike before, ItemLike ... blocks) {
        for (ItemLike block : blocks) {
            if (block == Blocks.AIR || before == Blocks.AIR) continue;
            event.insertBefore(FUNCTION.apply(before), FUNCTION.apply(block), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
            block17: for (String woodType : WOOD_TYPES) {
                if (woodType.equals("pale_oak") && !ModList.get().isLoaded("vanillabackport")) continue;
                Block planks = CarvedWood.getBlockFromString("minecraft", woodType + "_planks");
                Block PlanksP = CarvedWood.getBlockFromString(woodType + "_panels");
                Block bPlanks = CarvedWood.getBlockFromString(woodType + "_boards");
                Block sPlanks = CarvedWood.getBlockFromString("smooth_" + woodType + "_boards");
                Block planksTiles = CarvedWood.getBlockFromString(woodType + "_tiles");
                Block mPlanks = CarvedWood.getBlockFromString(woodType + "_mosaic");
                Block cPlanks = CarvedWood.getBlockFromString("carved_" + woodType + "_planks");
                Block lPlanks = CarvedWood.getBlockFromString(woodType + "_lantern_block");
                Block pPlanks = CarvedWood.getBlockFromString(woodType + "_pillar");
                Block planksStairs = CarvedWood.getBlockFromString("minecraft", woodType + "_stairs");
                Block mPlanksStairs = CarvedWood.getBlockFromString(woodType + "_mosaic_stairs");
                Block tPlanksStairs = CarvedWood.getBlockFromString(woodType + "_tile_stairs");
                Block planksSlab = CarvedWood.getBlockFromString("minecraft", woodType + "_slab");
                Block mPlanksSlab = CarvedWood.getBlockFromString(woodType + "_mosaic_slab");
                Block tPlanksSlab = CarvedWood.getBlockFromString(woodType + "_tile_slab");
                String trunkType = switch (woodType) {
                    case "crimson", "warped" -> "_stem";
                    case "bamboo" -> "";
                    default -> "_log";
                };
                Block log = CarvedWood.getBlockFromString("minecraft", woodType + trunkType);
                Block strippedLog = CarvedWood.getBlockFromString("minecraft", "stripped_" + woodType + trunkType);
                Block logBundle = CarvedWood.getBlockFromString(woodType + trunkType + "_bundle");
                Block strippedLogBundle = CarvedWood.getBlockFromString("stripped_" + woodType + trunkType + "_bundle");
                switch (woodType) {
                    case "bamboo": {
                        CarvedWood.addAfter(event, (ItemLike)Blocks.BAMBOO_BLOCK, new ItemLike[]{logBundle});
                        CarvedWood.addAfter(event, (ItemLike)Blocks.STRIPPED_BAMBOO_BLOCK, new ItemLike[]{strippedLogBundle});
                        CarvedWood.addAfter(event, (ItemLike)Blocks.BAMBOO_PLANKS, new ItemLike[]{PlanksP});
                        CarvedWood.addAfter(event, (ItemLike)Blocks.BAMBOO_MOSAIC, new ItemLike[]{planksTiles, bPlanks, sPlanks, cPlanks, lPlanks, pPlanks});
                        CarvedWood.addAfter(event, (ItemLike)Blocks.BAMBOO_MOSAIC_STAIRS, new ItemLike[]{tPlanksStairs});
                        CarvedWood.addAfter(event, (ItemLike)Blocks.BAMBOO_MOSAIC_SLAB, new ItemLike[]{tPlanksSlab});
                        continue block17;
                    }
                    case "pale_oak": {
                        CarvedWood.addAfter(event, (ItemLike)Blocks.CHERRY_BUTTON, new ItemLike[]{logBundle});
                        CarvedWood.addAfter(event, (ItemLike)Blocks.CHERRY_BUTTON, new ItemLike[]{strippedLogBundle});
                        CarvedWood.addAfter(event, (ItemLike)Blocks.CHERRY_BUTTON, new ItemLike[]{PlanksP, mPlanks, planksTiles, bPlanks, sPlanks, cPlanks, lPlanks, pPlanks});
                        CarvedWood.addAfter(event, (ItemLike)Blocks.CHERRY_BUTTON, new ItemLike[]{mPlanksStairs, tPlanksStairs});
                        CarvedWood.addAfter(event, (ItemLike)Blocks.CHERRY_BUTTON, new ItemLike[]{mPlanksSlab, tPlanksSlab});
                        continue block17;
                    }
                }
                CarvedWood.addAfter(event, (ItemLike)log, new ItemLike[]{logBundle});
                CarvedWood.addAfter(event, (ItemLike)strippedLog, new ItemLike[]{strippedLogBundle});
                CarvedWood.addAfter(event, (ItemLike)planks, new ItemLike[]{PlanksP, mPlanks, planksTiles, bPlanks, sPlanks, cPlanks, lPlanks, pPlanks});
                CarvedWood.addAfter(event, (ItemLike)planksStairs, new ItemLike[]{mPlanksStairs, tPlanksStairs});
                CarvedWood.addAfter(event, (ItemLike)planksSlab, new ItemLike[]{mPlanksSlab, tPlanksSlab});
            }
        }
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            for (String woodType : WOOD_TYPES.reversed()) {
                if (woodType.equals("pale_oak") && !ModList.get().isLoaded("vanillabackport")) continue;
                Block woodenLantern = CarvedWood.getBlockFromString(woodType + "_lantern");
                CarvedWood.addAfter(event, (ItemLike)Blocks.SOUL_LANTERN, new ItemLike[]{woodenLantern});
                if (woodType != "oak") {
                    Block craftingTable = CarvedWood.getBlockFromString(woodType + "_crafting_table");
                    Block ladder = CarvedWood.getBlockFromString(woodType + "_ladder");
                    Block campfire = CarvedWood.getBlockFromString(woodType + "_campfire");
                    Block soulCampfire = CarvedWood.getBlockFromString("soul_" + woodType + "_campfire");
                    Block bookshelf = CarvedWood.getBlockFromString(woodType + "_bookshelf");
                    Block chiseled_bookshelf = CarvedWood.getBlockFromString("chiseled_" + woodType + "_bookshelf");
                    Block lectern = CarvedWood.getBlockFromString(woodType + "_lectern");
                    Block beehive = CarvedWood.getBlockFromString(woodType + "_beehive");
                    CarvedWood.addAfter(event, (ItemLike)Blocks.CRAFTING_TABLE, new ItemLike[]{craftingTable});
                    CarvedWood.addAfter(event, (ItemLike)Blocks.LADDER, new ItemLike[]{ladder});
                    CarvedWood.addAfter(event, (ItemLike)Blocks.CAMPFIRE, new ItemLike[]{campfire});
                    CarvedWood.addAfter(event, (ItemLike)Blocks.SOUL_CAMPFIRE, new ItemLike[]{soulCampfire});
                    CarvedWood.addAfter(event, (ItemLike)Blocks.CHISELED_BOOKSHELF, new ItemLike[]{bookshelf});
                    CarvedWood.addAfter(event, (ItemLike)bookshelf, new ItemLike[]{chiseled_bookshelf});
                    CarvedWood.addAfter(event, (ItemLike)Blocks.LECTERN, new ItemLike[]{lectern});
                    CarvedWood.addAfter(event, (ItemLike)Blocks.BEEHIVE, new ItemLike[]{beehive});
                }
                if (woodType != "spruce" && woodType != "oak") {
                    Block barrel = CarvedWood.getBlockFromString(woodType + "_barrel");
                    CarvedWood.addAfter(event, (ItemLike)Blocks.BARREL, new ItemLike[]{barrel});
                }
                Block chest = CarvedWood.getBlockFromString(woodType + "_chest");
                CarvedWood.addAfter(event, (ItemLike)Blocks.CHEST, new ItemLike[]{chest});
            }
            CarvedWood.addBefore(event, (ItemLike)Blocks.BARREL, (ItemLike)CWBlocks.OAK_BARREL.get());
        }
        if (event.getTabKey() == CreativeModeTabs.REDSTONE_BLOCKS) {
            for (String woodType : WOOD_TYPES.reversed()) {
                if (woodType.equals("pale_oak") && !ModList.get().isLoaded("vanillabackport")) continue;
                Block chest = CarvedWood.getBlockFromString(woodType + "_chest");
                CarvedWood.addAfter(event, (ItemLike)Blocks.CHEST, new ItemLike[]{chest});
                Block trappedChest = CarvedWood.getBlockFromString("trapped_" + woodType + "_chest");
                CarvedWood.addAfter(event, (ItemLike)Blocks.TRAPPED_CHEST, new ItemLike[]{trappedChest});
                if (woodType.equals("oak")) continue;
                Block crafter = CarvedWood.getBlockFromString(woodType + "_crafter");
                CarvedWood.addAfter(event, (ItemLike)Blocks.CRAFTER, new ItemLike[]{crafter});
            }
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> CWPoiType.init());
    }

    public static Block getBlockFromString(String block) {
        return CarvedWood.getBlockFromString(MOD_ID, block);
    }

    public static Block getBlockFromString(String nameSpace, String block) {
        ResourceLocation blockLocation = ResourceLocation.fromNamespaceAndPath((String)nameSpace, (String)block);
        return (Block)BuiltInRegistries.BLOCK.get(blockLocation);
    }

    public static Item getItemFromString(String item) {
        return CarvedWood.getItemFromString(MOD_ID, item);
    }

    public static Item getItemFromString(String nameSpace, String item) {
        ResourceLocation itemLocation = ResourceLocation.fromNamespaceAndPath((String)nameSpace, (String)item);
        return (Item)BuiltInRegistries.ITEM.get(itemLocation);
    }

    @EventBusSubscriber(modid="carved_wood", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(CWModelLayers.CHEST, CWChestRenderer::createSingleBodyLayer);
            event.registerLayerDefinition(CWModelLayers.DOUBLE_CHEST_LEFT, CWChestRenderer::createDoubleBodyLeftLayer);
            event.registerLayerDefinition(CWModelLayers.DOUBLE_CHEST_RIGHT, CWChestRenderer::createDoubleBodyRightLayer);
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            BlockEntityRenderers.register(CWBlockEntities.CHEST.get(), CWChestRenderer::new);
            BlockEntityRenderers.register(CWBlockEntities.TRAPPED_CHEST.get(), CWChestRenderer::new);
            BlockEntityRenderers.register(CWBlockEntities.CAMPFIRE.get(), CWCampfireRenderer::new);
            BlockEntityRenderers.register(CWBlockEntities.LECTERN.get(), LecternRenderer::new);
            for (String woodType : WOOD_TYPES) {
                ItemBlockRenderTypes.setRenderLayer((Block)CarvedWood.getBlockFromString(woodType + "_lantern"), (RenderType)RenderType.cutout());
                ItemBlockRenderTypes.setRenderLayer((Block)CarvedWood.getBlockFromString(woodType + "_campfire"), (RenderType)RenderType.cutout());
                ItemBlockRenderTypes.setRenderLayer((Block)CarvedWood.getBlockFromString("soul_" + woodType + "_campfire"), (RenderType)RenderType.cutout());
                ItemBlockRenderTypes.setRenderLayer((Block)CarvedWood.getBlockFromString(woodType + "_ladder"), (RenderType)RenderType.cutout());
            }
        }
    }
}

