/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.carved_wood.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.im_maker.carved_wood.common.block.custom.CWLecternBlock;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.EnchantTableRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CWLecternRenderer
implements BlockEntityRenderer<LecternBlockEntity> {
    private final BookModel bookModel;

    public CWLecternRenderer(BlockEntityRendererProvider.Context pContext) {
        this.bookModel = new BookModel(pContext.bakeLayer(ModelLayers.BOOK));
    }

    public void render(LecternBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        BlockState blockstate = pBlockEntity.getBlockState();
        if (((Boolean)blockstate.getValue((Property)CWLecternBlock.HAS_BOOK)).booleanValue()) {
            pPoseStack.pushPose();
            pPoseStack.translate(0.5f, 1.0625f, 0.5f);
            float f = ((Direction)blockstate.getValue((Property)CWLecternBlock.FACING)).getClockWise().toYRot();
            pPoseStack.mulPose(Axis.YP.rotationDegrees(-f));
            pPoseStack.mulPose(Axis.ZP.rotationDegrees(67.5f));
            pPoseStack.translate(0.0f, -0.125f, 0.0f);
            this.bookModel.setupAnim(0.0f, 0.1f, 0.9f, 1.2f);
            VertexConsumer vertexconsumer = EnchantTableRenderer.BOOK_LOCATION.buffer(pBuffer, RenderType::entitySolid);
            this.bookModel.render(pPoseStack, vertexconsumer, pPackedLight, pPackedOverlay, -1);
            pPoseStack.popPose();
        }
    }
}

