/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.carved_wood.common.block.custom;

import net.im_maker.carved_wood.common.block.block_values.CWBlockStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BigBlock
extends RotatedPillarBlock {
    private final Boolean isFlammable;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final BooleanProperty ODD = CWBlockStateProperties.ODD;
    public static final BooleanProperty END_ODD = CWBlockStateProperties.END_ODD;

    public BigBlock(BlockBehaviour.Properties pProperties, Boolean isFlammable) {
        super(pProperties);
        this.isFlammable = isFlammable;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ODD, (Comparable)Boolean.valueOf(false))).setValue((Property)END_ODD, (Comparable)Boolean.valueOf(false))).setValue(AXIS, (Comparable)Direction.Axis.Y));
    }

    public BigBlock(BlockBehaviour.Properties pProperties) {
        this(pProperties, true);
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.isFlammable != false ? 20 : super.getFlammability(state, level, pos, direction);
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.isFlammable != false ? 5 : super.getFlammability(state, level, pos, direction);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Boolean isEndOdd;
        Boolean isOdd;
        BlockPos blockPos = context.getClickedPos();
        Direction.Axis placedAxis = context.getClickedFace().getAxis();
        int x = blockPos.getX();
        int y = blockPos.getY();
        int z = blockPos.getZ();
        if (placedAxis == Direction.Axis.Y) {
            isOdd = y % 2 == 0;
            isEndOdd = x % 2 == 0;
        } else {
            isOdd = x % 2 == 0 ^ z % 2 == 0;
            isEndOdd = placedAxis == Direction.Axis.X ? Boolean.valueOf(x % 2 == 0) : Boolean.valueOf(z % 2 == 0);
        }
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ODD, (Comparable)isOdd)).setValue((Property)END_ODD, (Comparable)isEndOdd)).setValue(AXIS, (Comparable)context.getClickedFace().getAxis());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{ODD, END_ODD, AXIS});
    }
}

