/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.carved_wood.common.block.custom;

import net.im_maker.carved_wood.common.block.entity.CWBlockEntities;
import net.im_maker.carved_wood.common.block.entity.custom.CWChestBlockEntity;
import net.im_maker.carved_wood.common.block.entity.custom.CWTrappedChestBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class CWTrappedChestBlock
extends ChestBlock {
    private final String chestName;

    public CWTrappedChestBlock(String name, BlockBehaviour.Properties properties) {
        super(properties, CWBlockEntities.TRAPPED_CHEST::get);
        this.chestName = name;
    }

    protected Stat<ResourceLocation> getOpenChestStat() {
        return Stats.CUSTOM.get((Object)Stats.TRIGGER_TRAPPED_CHEST);
    }

    public boolean isSignalSource(BlockState pState) {
        return true;
    }

    public int getSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return Mth.clamp((int)CWChestBlockEntity.getOpenCount((BlockGetter)pBlockAccess, (BlockPos)pPos), (int)0, (int)15);
    }

    public int getDirectSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return pSide == Direction.UP ? pBlockState.getSignal(pBlockAccess, pPos, pSide) : 0;
    }

    public String getChestName() {
        return this.chestName;
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new CWTrappedChestBlockEntity(blockPos, blockState);
    }
}

