/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.carved_wood.compatibility.jei;

import java.util.ArrayList;
import java.util.List;
import net.im_maker.carved_wood.common.util.CWTags;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public final class CarvedWoodRecipeMaker {
    private static final String BARREL_GROUP = "jei.carved_wood.barrel";
    private static final String BEEHIVE_GROUP = "jei.carved_wood.beehive";
    private static final String BOOKSHELF_GROUP = "jei.carved_wood.bookshelf";
    private static final String CAMPFIRE_GROUP = "jei.carved_wood.campfire";
    private static final String CHEST_GROUP = "jei.carved_wood.chest";
    private static final String CHISELED_BOOKSHELF_GROUP = "jei.carved_wood.chiseled_bookshelf";
    private static final String CRAFTING_TABLE_GROUP = "jei.carved_wood.crafting_table";
    private static final String LADDER_GROUP = "jei.carved_wood.ladder";
    private static final String LECTERN_GROUP = "jei.carved_wood.lectern";
    private static final String SOUL_CAMPFIRE_GROUP = "jei.carved_wood.soul_campfire";

    public static List<RecipeHolder<CraftingRecipe>> createCWRecipes() {
        ArrayList<RecipeHolder<CraftingRecipe>> recipes = new ArrayList<RecipeHolder<CraftingRecipe>>();
        recipes.add(CarvedWoodRecipeMaker.addBarrelRecipe());
        recipes.add(CarvedWoodRecipeMaker.addBeehiveRecipe());
        recipes.add(CarvedWoodRecipeMaker.addBookshelfRecipe());
        recipes.add(CarvedWoodRecipeMaker.addCampfireRecipe());
        recipes.add(CarvedWoodRecipeMaker.addChestRecipe());
        recipes.add(CarvedWoodRecipeMaker.addChiseledBookshelfRecipe());
        recipes.add(CarvedWoodRecipeMaker.addCraftingTableRecipe());
        recipes.add(CarvedWoodRecipeMaker.addLadderRecipe());
        recipes.add(CarvedWoodRecipeMaker.addLecternRecipe());
        recipes.add(CarvedWoodRecipeMaker.addSoulCampfireRecipe());
        return recipes;
    }

    private static RecipeHolder<CraftingRecipe> addBarrelRecipe() {
        Ingredient filteredPlanks = CarvedWoodRecipeMaker.createFilteredPlanksIngredient();
        Ingredient filteredSlabs = CarvedWoodRecipeMaker.createFilteredSlabsIngredient();
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{filteredPlanks, filteredSlabs, filteredPlanks, filteredPlanks, Ingredient.EMPTY, filteredPlanks, filteredPlanks, filteredSlabs, filteredPlanks});
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"carved_wood", (String)"jei.carved_wood.barrel.barrel");
        ShapelessRecipe recipe = new ShapelessRecipe("jei.carved_wood.barrel.barrel", CraftingBookCategory.MISC, new ItemStack((ItemLike)Items.BARREL), inputs);
        return new RecipeHolder(id, (Recipe)recipe);
    }

    private static RecipeHolder<CraftingRecipe> addBeehiveRecipe() {
        Ingredient filteredPlanks = CarvedWoodRecipeMaker.createFilteredPlanksIngredient();
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{filteredPlanks, filteredPlanks, filteredPlanks, Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEYCOMB}), Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEYCOMB}), Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEYCOMB}), filteredPlanks, filteredPlanks, filteredPlanks});
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"carved_wood", (String)"jei.carved_wood.beehive.beehive");
        ShapelessRecipe recipe = new ShapelessRecipe("jei.carved_wood.beehive.beehive", CraftingBookCategory.MISC, new ItemStack((ItemLike)Items.BEEHIVE), inputs);
        return new RecipeHolder(id, (Recipe)recipe);
    }

    private static RecipeHolder<CraftingRecipe> addBookshelfRecipe() {
        Ingredient filteredPlanks = CarvedWoodRecipeMaker.createFilteredPlanksIngredient();
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{filteredPlanks, filteredPlanks, filteredPlanks, Ingredient.of((ItemLike[])new ItemLike[]{Items.BOOK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BOOK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BOOK}), filteredPlanks, filteredPlanks, filteredPlanks});
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"carved_wood", (String)"jei.carved_wood.bookshelf.bookshelf");
        ShapelessRecipe recipe = new ShapelessRecipe("jei.carved_wood.bookshelf.bookshelf", CraftingBookCategory.MISC, new ItemStack((ItemLike)Items.BOOKSHELF), inputs);
        return new RecipeHolder(id, (Recipe)recipe);
    }

    private static RecipeHolder<CraftingRecipe> addCampfireRecipe() {
        Ingredient filteredLogs = CarvedWoodRecipeMaker.createFilteredLogsIngredient();
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.EMPTY, Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK}), Ingredient.EMPTY, Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK}), Ingredient.of((TagKey)ItemTags.COALS), Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK}), filteredLogs, filteredLogs, filteredLogs});
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"carved_wood", (String)"jei.carved_wood.campfire.campfire");
        ShapelessRecipe recipe = new ShapelessRecipe("jei.carved_wood.campfire.campfire", CraftingBookCategory.MISC, new ItemStack((ItemLike)Items.CAMPFIRE), inputs);
        return new RecipeHolder(id, (Recipe)recipe);
    }

    private static RecipeHolder<CraftingRecipe> addChestRecipe() {
        Ingredient filteredPlanks = CarvedWoodRecipeMaker.createFilteredPlanksIngredient();
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{filteredPlanks, filteredPlanks, filteredPlanks, filteredPlanks, Ingredient.EMPTY, filteredPlanks, filteredPlanks, filteredPlanks, filteredPlanks});
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"carved_wood", (String)"jei.carved_wood.chest.chest");
        ShapelessRecipe recipe = new ShapelessRecipe("jei.carved_wood.chest.chest", CraftingBookCategory.MISC, new ItemStack((ItemLike)Items.CHEST), inputs);
        return new RecipeHolder(id, (Recipe)recipe);
    }

    private static RecipeHolder<CraftingRecipe> addChiseledBookshelfRecipe() {
        Ingredient filteredPlanks = CarvedWoodRecipeMaker.createFilteredPlanksIngredient();
        Ingredient filteredSlabs = CarvedWoodRecipeMaker.createFilteredSlabsIngredient();
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{filteredPlanks, filteredPlanks, filteredPlanks, filteredSlabs, filteredSlabs, filteredSlabs, filteredPlanks, filteredPlanks, filteredPlanks});
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"carved_wood", (String)"jei.carved_wood.chiseled_bookshelf.chiseled_bookshelf");
        ShapelessRecipe recipe = new ShapelessRecipe("jei.carved_wood.chiseled_bookshelf.chiseled_bookshelf", CraftingBookCategory.MISC, new ItemStack((ItemLike)Items.CHISELED_BOOKSHELF), inputs);
        return new RecipeHolder(id, (Recipe)recipe);
    }

    private static RecipeHolder<CraftingRecipe> addCraftingTableRecipe() {
        Ingredient filteredPlanks = CarvedWoodRecipeMaker.createFilteredPlanksIngredient();
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{filteredPlanks, filteredPlanks, Ingredient.EMPTY, filteredPlanks, filteredPlanks, Ingredient.EMPTY, Ingredient.EMPTY, Ingredient.EMPTY, Ingredient.EMPTY});
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"carved_wood", (String)"jei.carved_wood.crafting_table.crafting_table");
        ShapelessRecipe recipe = new ShapelessRecipe("jei.carved_wood.crafting_table.crafting_table", CraftingBookCategory.MISC, new ItemStack((ItemLike)Items.CRAFTING_TABLE), inputs);
        return new RecipeHolder(id, (Recipe)recipe);
    }

    private static RecipeHolder<CraftingRecipe> addLadderRecipe() {
        Ingredient filteredPlanks = CarvedWoodRecipeMaker.createFilteredPlanksIngredient();
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK}), Ingredient.EMPTY, Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK}), filteredPlanks, Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK}), Ingredient.EMPTY, Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK})});
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"carved_wood", (String)"jei.carved_wood.ladder.ladder");
        ShapelessRecipe recipe = new ShapelessRecipe("jei.carved_wood.ladder.ladder", CraftingBookCategory.MISC, new ItemStack((ItemLike)Items.LADDER), inputs);
        return new RecipeHolder(id, (Recipe)recipe);
    }

    private static RecipeHolder<CraftingRecipe> addLecternRecipe() {
        Ingredient filteredSlabs = CarvedWoodRecipeMaker.createFilteredSlabsIngredient();
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{filteredSlabs, filteredSlabs, filteredSlabs, Ingredient.EMPTY, Ingredient.of((TagKey)Tags.Items.BOOKSHELVES), Ingredient.EMPTY, Ingredient.EMPTY, filteredSlabs, Ingredient.EMPTY});
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"carved_wood", (String)"jei.carved_wood.lectern.lectern");
        ShapelessRecipe recipe = new ShapelessRecipe("jei.carved_wood.lectern.lectern", CraftingBookCategory.MISC, new ItemStack((ItemLike)Items.LECTERN), inputs);
        return new RecipeHolder(id, (Recipe)recipe);
    }

    private static RecipeHolder<CraftingRecipe> addSoulCampfireRecipe() {
        Ingredient filteredLogs = CarvedWoodRecipeMaker.createFilteredLogsIngredient();
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.EMPTY, Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK}), Ingredient.EMPTY, Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK}), Ingredient.of((TagKey)ItemTags.SOUL_FIRE_BASE_BLOCKS), Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK}), filteredLogs, filteredLogs, filteredLogs});
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"carved_wood", (String)"jei.carved_wood.soul_campfire.soul_campfire");
        ShapelessRecipe recipe = new ShapelessRecipe("jei.carved_wood.soul_campfire.soul_campfire", CraftingBookCategory.MISC, new ItemStack((ItemLike)Items.SOUL_CAMPFIRE), inputs);
        return new RecipeHolder(id, (Recipe)recipe);
    }

    private static Ingredient createFilteredPlanksIngredient() {
        ArrayList<ItemStack> filteredPlanks = new ArrayList<ItemStack>();
        for (Holder holder : BuiltInRegistries.ITEM.getTagOrEmpty(ItemTags.PLANKS)) {
            if (holder.is(CWTags.Items.FLAG)) continue;
            filteredPlanks.add(new ItemStack(holder));
        }
        return Ingredient.of((ItemStack[])filteredPlanks.toArray(new ItemStack[0]));
    }

    private static Ingredient createFilteredSlabsIngredient() {
        ArrayList<ItemStack> filteredSlabs = new ArrayList<ItemStack>();
        for (Holder holder : BuiltInRegistries.ITEM.getTagOrEmpty(ItemTags.WOODEN_SLABS)) {
            if (holder.is(CWTags.Items.FLAG)) continue;
            filteredSlabs.add(new ItemStack(holder));
        }
        return Ingredient.of((ItemStack[])filteredSlabs.toArray(new ItemStack[0]));
    }

    private static Ingredient createFilteredLogsIngredient() {
        ArrayList<ItemStack> filteredLogs = new ArrayList<ItemStack>();
        for (Holder holder : BuiltInRegistries.ITEM.getTagOrEmpty(ItemTags.LOGS)) {
            if (holder.is(CWTags.Items.FLAG)) continue;
            filteredLogs.add(new ItemStack(holder));
        }
        return Ingredient.of((ItemStack[])filteredLogs.toArray(new ItemStack[0]));
    }

    private CarvedWoodRecipeMaker() {
    }
}

