/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.carved_wood.compatibility.jei;

import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.im_maker.carved_wood.common.block.custom.CWCraftingTableBlock;
import net.im_maker.carved_wood.compatibility.jei.CarvedWoodRecipeMaker;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

@JeiPlugin
public class JEICompat
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"carved_wood", (String)"jei_plugin");
    }

    private static Block[] getBlocks(Class<?> blockClass) {
        return (Block[])BuiltInRegistries.BLOCK.stream().filter(blockClass::isInstance).toArray(Block[]::new);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        for (Block craftingTables : JEICompat.getBlocks(CWCraftingTableBlock.class)) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)craftingTables), new RecipeType[]{RecipeTypes.CRAFTING});
            registration.addRecipeCatalyst(new ItemStack((ItemLike)craftingTables), new RecipeType[]{RecipeTypes.CRAFTING});
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List<RecipeHolder<CraftingRecipe>> CWRecipes2 = CarvedWoodRecipeMaker.createCWRecipes();
        registration.addRecipes(RecipeTypes.CRAFTING, CWRecipes2);
    }
}

