/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.carved_wood;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.im_maker.carved_wood.common.block.CWBlocks;
import net.im_maker.carved_wood.common.block.entity.CWBlockEntities;
import net.im_maker.carved_wood.common.item.CWItems;
import net.im_maker.carved_wood.common.recipe.CWRecipes;
import net.im_maker.carved_wood.common.util.CWFuelRegistry;
import net.im_maker.carved_wood.common.util.CWPoiType;
import net.im_maker.carved_wood.common.util.DataPackRegistrar;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarvedWood
implements ModInitializer {
    public static final String MOD_ID = "carved_wood";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"carved_wood");
    public static final List<String> WOOD_TYPES = new ArrayList<String>(Arrays.asList("oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "mangrove", "cherry", "pale_oak", "bamboo", "crimson", "warped"));

    public void onInitialize() {
        DataPackRegistrar.loadBuiltinResourcePacks();
        CWItems.registerItems();
        CWBlocks.registerBlocks();
        CWBlockEntities.registerBlockEntities();
        CWFuelRegistry.registerFuel();
        CWPoiType.init();
        CWRecipes.registerRecipeSerializers();
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40195).register(CarvedWood::addToBuildingBlocksTap);
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40197).register(CarvedWood::addToFunctionalBlocksTap);
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40198).register(CarvedWood::addToRedstoneBlocksTap);
        CarvedWood.addPackFinders();
    }

    public static void addPackFinders() {
        ModContainer create = (ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow(() -> new IllegalStateException("CarvedWood's ModContainer couldn't be found!"));
        class_2960 packId = class_2960.method_60655((String)MOD_ID, (String)"recarved");
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)packId, (ModContainer)create, (String)"Recarved", (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
    }

    public static void addToBuildingBlocksTap(FabricItemGroupEntries entries) {
        block15: for (String woodType : WOOD_TYPES) {
            if (woodType.equals("pale_oak") && !FabricLoader.getInstance().isModLoaded("vanillabackport")) continue;
            class_2248 planks = CarvedWood.getBlockFromString("minecraft", woodType + "_planks");
            class_2248 planksTiles = CarvedWood.getBlockFromString(woodType + "_tiles");
            class_2248 PlanksP = CarvedWood.getBlockFromString(woodType + "_panels");
            class_2248 bPlanks = CarvedWood.getBlockFromString(woodType + "_boards");
            class_2248 sPlanks = CarvedWood.getBlockFromString("smooth_" + woodType + "_boards");
            class_2248 mPlanks = CarvedWood.getBlockFromString(woodType + "_mosaic");
            class_2248 cPlanks = CarvedWood.getBlockFromString("carved_" + woodType + "_planks");
            class_2248 lPlanks = CarvedWood.getBlockFromString(woodType + "_lantern_block");
            class_2248 pPlanks = CarvedWood.getBlockFromString(woodType + "_pillar");
            class_2248 planksStairs = CarvedWood.getBlockFromString("minecraft", woodType + "_stairs");
            class_2248 mPlanksStairs = CarvedWood.getBlockFromString(woodType + "_mosaic_stairs");
            class_2248 tPlanksStairs = CarvedWood.getBlockFromString(woodType + "_tile_stairs");
            class_2248 planksSlab = CarvedWood.getBlockFromString("minecraft", woodType + "_slab");
            class_2248 mPlanksSlab = CarvedWood.getBlockFromString(woodType + "_mosaic_slab");
            class_2248 tPlanksSlab = CarvedWood.getBlockFromString(woodType + "_tile_slab");
            String trunkType = switch (woodType) {
                case "crimson", "warped" -> "_stem";
                case "bamboo" -> "";
                default -> "_log";
            };
            class_2248 log = CarvedWood.getBlockFromString("minecraft", woodType + trunkType);
            class_2248 strippedLog = CarvedWood.getBlockFromString("minecraft", "stripped_" + woodType + trunkType);
            class_2248 logBundle = CarvedWood.getBlockFromString(woodType + trunkType + "_bundle");
            class_2248 strippedLogBundle = CarvedWood.getBlockFromString("stripped_" + woodType + trunkType + "_bundle");
            switch (woodType) {
                case "bamboo": {
                    entries.addAfter((class_1935)class_2246.field_41072, new class_1935[]{logBundle});
                    entries.addAfter((class_1935)class_2246.field_41073, new class_1935[]{strippedLogBundle});
                    entries.addAfter((class_1935)class_2246.field_40294, new class_1935[]{PlanksP});
                    entries.addAfter((class_1935)class_2246.field_40295, new class_1935[]{planksTiles, bPlanks, sPlanks, cPlanks, lPlanks, pPlanks});
                    entries.addAfter((class_1935)class_2246.field_40288, new class_1935[]{tPlanksStairs});
                    entries.addAfter((class_1935)class_2246.field_40293, new class_1935[]{tPlanksSlab});
                    continue block15;
                }
            }
            entries.addAfter((class_1935)log, new class_1935[]{logBundle});
            entries.addAfter((class_1935)strippedLog, new class_1935[]{strippedLogBundle});
            entries.addAfter((class_1935)planks, new class_1935[]{PlanksP, mPlanks, planksTiles, bPlanks, sPlanks, cPlanks, lPlanks, pPlanks});
            entries.addAfter((class_1935)planksStairs, new class_1935[]{mPlanksStairs, tPlanksStairs});
            entries.addAfter((class_1935)planksSlab, new class_1935[]{mPlanksSlab, tPlanksSlab});
        }
    }

    public static void addToFunctionalBlocksTap(FabricItemGroupEntries entries) {
        for (String woodType : WOOD_TYPES.reversed()) {
            if (woodType.equals("pale_oak") && !FabricLoader.getInstance().isModLoaded("vanillabackport")) continue;
            class_2248 woodenLantern = CarvedWood.getBlockFromString(woodType + "_lantern");
            entries.addAfter((class_1935)class_2246.field_22110, new class_1935[]{woodenLantern});
            if (woodType != "oak") {
                class_2248 craftingTable = CarvedWood.getBlockFromString(woodType + "_crafting_table");
                class_2248 ladder = CarvedWood.getBlockFromString(woodType + "_ladder");
                class_2248 campfire = CarvedWood.getBlockFromString(woodType + "_campfire");
                class_2248 soulCampfire = CarvedWood.getBlockFromString("soul_" + woodType + "_campfire");
                class_2248 bookshelf = CarvedWood.getBlockFromString(woodType + "_bookshelf");
                class_2248 chiseled_bookshelf = CarvedWood.getBlockFromString("chiseled_" + woodType + "_bookshelf");
                class_2248 lectern = CarvedWood.getBlockFromString(woodType + "_lectern");
                class_2248 beehive = CarvedWood.getBlockFromString(woodType + "_beehive");
                entries.addAfter((class_1935)class_2246.field_9980, new class_1935[]{craftingTable});
                entries.addAfter((class_1935)class_2246.field_9983, new class_1935[]{ladder});
                entries.addAfter((class_1935)class_2246.field_17350, new class_1935[]{campfire});
                entries.addAfter((class_1935)class_2246.field_23860, new class_1935[]{soulCampfire});
                entries.addAfter((class_1935)class_2246.field_40276, new class_1935[]{bookshelf});
                entries.addAfter((class_1935)bookshelf, new class_1935[]{chiseled_bookshelf});
                entries.addAfter((class_1935)class_2246.field_16330, new class_1935[]{lectern});
                entries.addAfter((class_1935)class_2246.field_20422, new class_1935[]{beehive});
            }
            if (woodType != "spruce" && woodType != "oak") {
                class_2248 barrel = CarvedWood.getBlockFromString(woodType + "_barrel");
                entries.addAfter((class_1935)class_2246.field_16328, new class_1935[]{barrel});
            }
            class_2248 chest = CarvedWood.getBlockFromString(woodType + "_chest");
            entries.addAfter((class_1935)class_2246.field_10034, new class_1935[]{chest});
        }
        entries.addBefore((class_1935)class_2246.field_16328, new class_1935[]{CWBlocks.OAK_BARREL});
    }

    public static void addToRedstoneBlocksTap(FabricItemGroupEntries entries) {
        for (String woodType : WOOD_TYPES.reversed()) {
            if (woodType.equals("pale_oak") && !FabricLoader.getInstance().isModLoaded("vanillabackport")) continue;
            class_2248 chest = CarvedWood.getBlockFromString(woodType + "_chest");
            entries.addAfter((class_1935)class_2246.field_10034, new class_1935[]{chest});
            class_2248 trappedChest = CarvedWood.getBlockFromString("trapped_" + woodType + "_chest");
            entries.addAfter((class_1935)class_2246.field_10380, new class_1935[]{trappedChest});
            if (woodType.equals("oak")) continue;
            class_2248 crafter = CarvedWood.getBlockFromString(woodType + "_crafter");
            entries.addAfter((class_1935)class_2246.field_46797, new class_1935[]{crafter});
        }
    }

    public static class_2248 getBlockFromString(String block) {
        return CarvedWood.getBlockFromString(MOD_ID, block);
    }

    public static class_2248 getBlockFromString(String nameSpace, String block) {
        class_2960 blockLocation = class_2960.method_60655((String)nameSpace, (String)block);
        return (class_2248)class_7923.field_41175.method_10223(blockLocation);
    }

    public static class_1792 getItemFromString(String item) {
        return CarvedWood.getItemFromString(MOD_ID, item);
    }

    public static class_1792 getItemFromString(String nameSpace, String item) {
        class_2960 itemLocation = class_2960.method_60655((String)nameSpace, (String)item);
        return (class_1792)class_7923.field_41178.method_10223(itemLocation);
    }

    public static class_2248[] getBlocks(Class<?> ... blockClasses) {
        return (class_2248[])class_7923.field_41175.method_10220().filter(block -> Stream.of(blockClasses).anyMatch(clazz -> clazz.isInstance(block))).toArray(class_2248[]::new);
    }
}

