/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.carved_wood.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.im_maker.carved_wood.common.block.custom.CWBarrelBlock;
import net.im_maker.carved_wood.common.block.custom.CWBeehiveBlock;
import net.im_maker.carved_wood.common.block.custom.CWLecternBlock;
import net.im_maker.carved_wood.common.util.CWTags;
import net.im_maker.carved_wood.mixin.MixinPoiTypesAccessor;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_4158;
import net.minecraft.class_6880;
import net.minecraft.class_7477;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class CWPoiType {
    public static void init() {
        Map<class_2680, class_6880<class_4158>> poiStatesToType = MixinPoiTypesAccessor.getPoiStatesToType();
        class_4158 fishermanPoiType = (class_4158)class_7923.field_41128.method_10223(class_7477.field_39283.method_29177());
        class_4158 librarianPoiType = (class_4158)class_7923.field_41128.method_10223(class_7477.field_39286.method_29177());
        class_4158 beehivePoiType = (class_4158)class_7923.field_41128.method_10223(class_7477.field_39293.method_29177());
        ArrayList<class_2680> fishermanBlockStates = new ArrayList<class_2680>(fishermanPoiType.comp_815());
        ArrayList<class_2680> librarianBlockStates = new ArrayList<class_2680>(librarianPoiType.comp_815());
        ArrayList<class_2680> beehiveBlockStates = new ArrayList<class_2680>(beehivePoiType.comp_815());
        for (class_2248 block : class_7923.field_41175) {
            ArrayList<class_2680> blockStates;
            if (CWPoiType.isInBarrels(block)) {
                blockStates = new ArrayList<class_2680>(CWPoiType.getPOIFisherman());
                for (class_2680 blockState : blockStates) {
                    poiStatesToType.putIfAbsent(blockState, (class_6880<class_4158>)class_7923.field_41128.method_47983((Object)fishermanPoiType));
                }
                fishermanBlockStates.addAll(blockStates);
            }
            if (CWPoiType.isInLectern(block)) {
                blockStates = new ArrayList<class_2680>(CWPoiType.getPOILibrarian());
                for (class_2680 blockState : blockStates) {
                    poiStatesToType.putIfAbsent(blockState, (class_6880<class_4158>)class_7923.field_41128.method_47983((Object)librarianPoiType));
                }
                librarianBlockStates.addAll(blockStates);
            }
            if (!CWPoiType.isInBeehive(block)) continue;
            blockStates = new ArrayList<class_2680>(CWPoiType.getPOIBeehive());
            for (class_2680 blockState : blockStates) {
                poiStatesToType.putIfAbsent(blockState, (class_6880<class_4158>)class_7923.field_41128.method_47983((Object)beehivePoiType));
            }
            beehiveBlockStates.addAll(blockStates);
        }
    }

    private static Set<class_2680> getPOILibrarian() {
        HashSet<class_2680> states = new HashSet<class_2680>();
        class_7923.field_41175.method_10220().filter(CWPoiType::isInLectern).forEach(CWPoiType.addAllBlockStates(states));
        return states;
    }

    private static Set<class_2680> getPOIFisherman() {
        HashSet<class_2680> states = new HashSet<class_2680>();
        class_7923.field_41175.method_10220().filter(CWPoiType::isInBarrels).forEach(CWPoiType.addAllBlockStates(states));
        return states;
    }

    private static Set<class_2680> getPOIBeehive() {
        HashSet<class_2680> states = new HashSet<class_2680>();
        class_7923.field_41175.method_10220().filter(CWPoiType::isInBeehive).forEach(CWPoiType.addAllBlockStates(states));
        return states;
    }

    private static boolean isInBarrels(class_2248 block) {
        return block instanceof CWBarrelBlock || block.method_9564().method_26164(CWTags.Blocks.WOODEN_BARRELS);
    }

    private static boolean isInLectern(class_2248 block) {
        return block instanceof CWLecternBlock || block == class_2246.field_16330 || block.method_9564().method_26164(CWTags.Blocks.LECTERNS);
    }

    private static boolean isInBeehive(class_2248 block) {
        return block instanceof CWBeehiveBlock || block == class_2246.field_20422 || block.method_9564().method_26164(class_3481.field_20340);
    }

    @NotNull
    private static Consumer<class_2248> addAllBlockStates(Set<class_2680> states) {
        return block -> states.addAll((Collection<class_2680>)block.method_9595().method_11662());
    }
}

