/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.carved_wood;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.im_maker.carved_wood.client.renderer.CWModelLayers;
import net.im_maker.carved_wood.client.renderer.block.CWCampfireRenderer;
import net.im_maker.carved_wood.client.renderer.block.CWChestRenderer;
import net.im_maker.carved_wood.common.block.CWBlocks;
import net.im_maker.carved_wood.common.block.entity.CWBlockEntities;
import net.im_maker.carved_wood.common.item.CWItems;
import net.im_maker.carved_wood.common.recipe.CWRecipes;
import net.im_maker.carved_wood.common.util.CWPoiType;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.LecternRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="carved_wood")
@Mod.EventBusSubscriber(modid="carved_wood", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CarvedWood {
    public static final String MOD_ID = "carved_wood";
    private static final Function<ItemLike, ItemStack> FUNCTION = ItemStack::new;
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"carved_wood");
    public static final List<String> WOOD_TYPES = new ArrayList<String>(Arrays.asList("oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "mangrove", "cherry", "bamboo", "crimson", "warped"));

    public CarvedWood(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        CWBlocks.register(modEventBus);
        CWItems.register(modEventBus);
        CWRecipes.register(modEventBus);
        CWPoiType.register(modEventBus);
        CWBlockEntities.register(modEventBus);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::addCreative);
    }

    private static void addAfter(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> event, ItemLike after, ItemLike ... blocks) {
        for (int i = blocks.length - 1; i >= 0; --i) {
            ItemLike block = blocks[i];
            if (block == Blocks.AIR || after == Blocks.AIR) continue;
            event.putAfter((Object)FUNCTION.apply(after), (Object)FUNCTION.apply(block), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    private static void addBefore(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> event, ItemLike before, ItemLike ... blocks) {
        for (ItemLike block : blocks) {
            if (block == Blocks.AIR || before == Blocks.AIR) continue;
            event.putBefore((Object)FUNCTION.apply(before), (Object)FUNCTION.apply(block), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        MutableHashedLinkedMap entries = event.getEntries();
        if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
            block17: for (String woodType : WOOD_TYPES) {
                if (woodType.equals("pale_oak") && !ModList.get().isLoaded("vanillabackport")) continue;
                Block planks = CarvedWood.getBlockFromString(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + "_planks");
                Block PlanksP = CarvedWood.getBlockFromString(woodType + "_panels");
                Block bPlanks = CarvedWood.getBlockFromString(woodType + "_boards");
                Block sPlanks = CarvedWood.getBlockFromString("smooth_" + woodType + "_boards");
                Block planksTiles = CarvedWood.getBlockFromString(woodType + "_tiles");
                Block mPlanks = CarvedWood.getBlockFromString(woodType + "_mosaic");
                Block cPlanks = CarvedWood.getBlockFromString("carved_" + woodType + "_planks");
                Block lPlanks = CarvedWood.getBlockFromString(woodType + "_lantern_block");
                Block pPlanks = CarvedWood.getBlockFromString(woodType + "_pillar");
                Block planksStairs = CarvedWood.getBlockFromString(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + "_stairs");
                Block mPlanksStairs = CarvedWood.getBlockFromString(woodType + "_mosaic_stairs");
                Block tPlanksStairs = CarvedWood.getBlockFromString(woodType + "_tile_stairs");
                Block planksSlab = CarvedWood.getBlockFromString(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + "_slab");
                Block mPlanksSlab = CarvedWood.getBlockFromString(woodType + "_mosaic_slab");
                Block tPlanksSlab = CarvedWood.getBlockFromString(woodType + "_tile_slab");
                String trunkType = switch (woodType) {
                    case "crimson", "warped" -> "_stem";
                    case "bamboo" -> "";
                    default -> "_log";
                };
                Block log = CarvedWood.getBlockFromString(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + trunkType);
                Block strippedLog = CarvedWood.getBlockFromString(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", "stripped_" + woodType + trunkType);
                Block logBundle = CarvedWood.getBlockFromString(woodType + trunkType + "_bundle");
                Block strippedLogBundle = CarvedWood.getBlockFromString("stripped_" + woodType + trunkType + "_bundle");
                switch (woodType) {
                    case "bamboo": {
                        CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.BAMBOO_BLOCK, new ItemLike[]{logBundle});
                        CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.STRIPPED_BAMBOO_BLOCK, new ItemLike[]{strippedLogBundle});
                        CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.BAMBOO_PLANKS, new ItemLike[]{PlanksP});
                        CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.BAMBOO_MOSAIC, new ItemLike[]{planksTiles, bPlanks, sPlanks, cPlanks, lPlanks, pPlanks});
                        CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.BAMBOO_MOSAIC_STAIRS, new ItemLike[]{tPlanksStairs});
                        CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.BAMBOO_MOSAIC_SLAB, new ItemLike[]{tPlanksSlab});
                        continue block17;
                    }
                    case "pale_oak": {
                        CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.CHERRY_BUTTON, new ItemLike[]{logBundle});
                        CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.CHERRY_BUTTON, new ItemLike[]{strippedLogBundle});
                        CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.CHERRY_BUTTON, new ItemLike[]{PlanksP, mPlanks, planksTiles, bPlanks, sPlanks, cPlanks, lPlanks, pPlanks});
                        CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.CHERRY_BUTTON, new ItemLike[]{mPlanksStairs, tPlanksStairs});
                        CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.CHERRY_BUTTON, new ItemLike[]{mPlanksSlab, tPlanksSlab});
                        continue block17;
                    }
                }
                CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)log, new ItemLike[]{logBundle});
                CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)strippedLog, new ItemLike[]{strippedLogBundle});
                CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)planks, new ItemLike[]{PlanksP, mPlanks, planksTiles, bPlanks, sPlanks, cPlanks, lPlanks, pPlanks});
                CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)planksStairs, new ItemLike[]{mPlanksStairs, tPlanksStairs});
                CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)planksSlab, new ItemLike[]{mPlanksSlab, tPlanksSlab});
            }
        }
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            for (String woodType : WOOD_TYPES.reversed()) {
                if (woodType.equals("pale_oak") && !ModList.get().isLoaded("vanillabackport")) continue;
                Block woodenLantern = CarvedWood.getBlockFromString(woodType + "_lantern");
                CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.SOUL_LANTERN, new ItemLike[]{woodenLantern});
                if (woodType != "oak") {
                    Block craftingTable = CarvedWood.getBlockFromString(woodType + "_crafting_table");
                    Block ladder = CarvedWood.getBlockFromString(woodType + "_ladder");
                    Block campfire = CarvedWood.getBlockFromString(woodType + "_campfire");
                    Block soulCampfire = CarvedWood.getBlockFromString("soul_" + woodType + "_campfire");
                    Block bookshelf = CarvedWood.getBlockFromString(woodType + "_bookshelf");
                    Block chiseled_bookshelf = CarvedWood.getBlockFromString("chiseled_" + woodType + "_bookshelf");
                    Block lectern = CarvedWood.getBlockFromString(woodType + "_lectern");
                    Block beehive = CarvedWood.getBlockFromString(woodType + "_beehive");
                    CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.CRAFTING_TABLE, new ItemLike[]{craftingTable});
                    CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.LADDER, new ItemLike[]{ladder});
                    CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.CAMPFIRE, new ItemLike[]{campfire});
                    CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.SOUL_CAMPFIRE, new ItemLike[]{soulCampfire});
                    CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.CHISELED_BOOKSHELF, new ItemLike[]{bookshelf});
                    CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)bookshelf, new ItemLike[]{chiseled_bookshelf});
                    CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.LECTERN, new ItemLike[]{lectern});
                    CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.BEEHIVE, new ItemLike[]{beehive});
                }
                if (woodType != "spruce" && woodType != "oak") {
                    Block barrel = CarvedWood.getBlockFromString(woodType + "_barrel");
                    CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.BARREL, new ItemLike[]{barrel});
                }
                Block chest = CarvedWood.getBlockFromString(woodType + "_chest");
                CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.CHEST, new ItemLike[]{chest});
            }
            CarvedWood.addBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.BARREL, (ItemLike)CWBlocks.OAK_BARREL.get());
        }
        if (event.getTabKey() == CreativeModeTabs.REDSTONE_BLOCKS) {
            for (String woodType : WOOD_TYPES.reversed()) {
                if (woodType.equals("pale_oak") && !ModList.get().isLoaded("vanillabackport")) continue;
                Block chest = CarvedWood.getBlockFromString(woodType + "_chest");
                CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.CHEST, new ItemLike[]{chest});
                Block trappedChest = CarvedWood.getBlockFromString("trapped_" + woodType + "_chest");
                CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.TRAPPED_CHEST, new ItemLike[]{trappedChest});
                if (woodType.equals("oak")) continue;
                Block crafter = CarvedWood.getBlockFromString(woodType + "_crafter");
                CarvedWood.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.CRAFTER, new ItemLike[]{crafter});
            }
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(CWPoiType::init);
    }

    public static Block getBlockFromString(String block) {
        return CarvedWood.getBlockFromString(MOD_ID, block);
    }

    public static Block getBlockFromString(String nameSpace, String block) {
        ResourceLocation blockLocation = ResourceLocation.fromNamespaceAndPath((String)nameSpace, (String)block);
        return (Block)ForgeRegistries.BLOCKS.getValue(blockLocation);
    }

    public static Item getItemFromString(String item) {
        return CarvedWood.getItemFromString(MOD_ID, item);
    }

    public static Item getItemFromString(String nameSpace, String item) {
        ResourceLocation itemLocation = ResourceLocation.fromNamespaceAndPath((String)nameSpace, (String)item);
        return (Item)ForgeRegistries.ITEMS.getValue(itemLocation);
    }

    @Mod.EventBusSubscriber(modid="carved_wood", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(CWModelLayers.CHEST, CWChestRenderer::createSingleBodyLayer);
            event.registerLayerDefinition(CWModelLayers.DOUBLE_CHEST_LEFT, CWChestRenderer::createDoubleBodyLeftLayer);
            event.registerLayerDefinition(CWModelLayers.DOUBLE_CHEST_RIGHT, CWChestRenderer::createDoubleBodyRightLayer);
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)CWBlockEntities.CHEST.get()), CWChestRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)CWBlockEntities.TRAPPED_CHEST.get()), CWChestRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)CWBlockEntities.CAMPFIRE.get()), CWCampfireRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)CWBlockEntities.LECTERN.get()), LecternRenderer::new);
            for (String woodType : WOOD_TYPES) {
                ItemBlockRenderTypes.setRenderLayer((Block)CarvedWood.getBlockFromString(woodType + "_lantern"), (RenderType)RenderType.cutout());
                ItemBlockRenderTypes.setRenderLayer((Block)CarvedWood.getBlockFromString(woodType + "_lantern"), (RenderType)RenderType.cutout());
                ItemBlockRenderTypes.setRenderLayer((Block)CarvedWood.getBlockFromString(woodType + "_campfire"), (RenderType)RenderType.cutout());
                ItemBlockRenderTypes.setRenderLayer((Block)CarvedWood.getBlockFromString("soul_" + woodType + "_campfire"), (RenderType)RenderType.cutout());
                ItemBlockRenderTypes.setRenderLayer((Block)CarvedWood.getBlockFromString(woodType + "_ladder"), (RenderType)RenderType.cutout());
            }
        }
    }
}

