/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.carved_wood.client.renderer;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CWModelLayers {
    private static final Set<ModelLayerLocation> ALL_MODELS = Sets.newHashSet();
    public static final ModelLayerLocation CHEST = CWModelLayers.register("chest");
    public static final ModelLayerLocation DOUBLE_CHEST_LEFT = CWModelLayers.register("double_chest_left");
    public static final ModelLayerLocation DOUBLE_CHEST_RIGHT = CWModelLayers.register("double_chest_right");
    public static final ModelLayerLocation CAMPFIRE = CWModelLayers.register("campfire");

    private static ModelLayerLocation register(String pPath) {
        return CWModelLayers.register(pPath, "main");
    }

    private static ModelLayerLocation register(String pPath, String pModel) {
        ModelLayerLocation modellayerlocation = CWModelLayers.createLocation(pPath, pModel);
        if (!ALL_MODELS.add(modellayerlocation)) {
            throw new IllegalStateException("Duplicate registration for " + String.valueOf(modellayerlocation));
        }
        return modellayerlocation;
    }

    private static ModelLayerLocation createLocation(String pPath, String pModel) {
        return new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"carved_wood", (String)pPath), pModel);
    }
}

