/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.carved_wood.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Calendar;
import net.im_maker.carved_wood.client.renderer.CWModelLayers;
import net.im_maker.carved_wood.client.renderer.ChestSheets;
import net.im_maker.carved_wood.common.block.custom.CWChestBlock;
import net.im_maker.carved_wood.common.block.custom.CWTrappedChestBlock;
import net.im_maker.carved_wood.common.item.custom.ChestBlockItem;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CWChestRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static final String BOTTOM = "bottom";
    private static final String LID = "lid";
    private static final String LOCK = "lock";
    private static final String Latch = "latch";
    private static final String HANDLE = "handle";
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;
    private final ModelPart latch;
    private final ModelPart handle;
    private final ModelPart doubleLeftLid;
    private final ModelPart doubleLeftBottom;
    private final ModelPart doubleLeftLock;
    private final ModelPart doubleLeftHandle;
    private final ModelPart doubleRightLid;
    private final ModelPart doubleRightBottom;
    private final ModelPart doubleRightLock;
    private final ModelPart doubleLatch;
    private final ModelPart doubleRightHandle;
    private boolean xmasTextures;

    public CWChestRenderer(BlockEntityRendererProvider.Context pContext) {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.xmasTextures = true;
        }
        ModelPart modelpart = pContext.bakeLayer(CWModelLayers.CHEST);
        this.bottom = modelpart.getChild(BOTTOM);
        this.lid = modelpart.getChild(LID);
        this.lock = modelpart.getChild(LOCK);
        this.latch = modelpart.getChild(Latch);
        this.handle = modelpart.getChild(HANDLE);
        ModelPart modelpart1 = pContext.bakeLayer(CWModelLayers.DOUBLE_CHEST_LEFT);
        this.doubleLeftBottom = modelpart1.getChild(BOTTOM);
        this.doubleLeftLid = modelpart1.getChild(LID);
        this.doubleLeftLock = modelpart1.getChild(LOCK);
        this.doubleLeftHandle = modelpart1.getChild(HANDLE);
        ModelPart modelpart2 = pContext.bakeLayer(CWModelLayers.DOUBLE_CHEST_RIGHT);
        this.doubleRightBottom = modelpart2.getChild(BOTTOM);
        this.doubleRightLid = modelpart2.getChild(LID);
        this.doubleRightLock = modelpart2.getChild(LOCK);
        this.doubleLatch = modelpart2.getChild(Latch);
        this.doubleRightHandle = modelpart2.getChild(HANDLE);
    }

    public static LayerDefinition createSingleBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(BOTTOM, CubeListBuilder.create().texOffs(0, 19).addBox(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild(LID, CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.addOrReplaceChild(LOCK, CubeListBuilder.create().texOffs(0, 0).addBox(7.0f, -2.0f, 14.0f, 2.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.addOrReplaceChild(Latch, CubeListBuilder.create().texOffs(0, 5).addBox(6.0f, -1.0f, 14.0f, 4.0f, 2.0f, 1.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.addOrReplaceChild(HANDLE, CubeListBuilder.create().texOffs(0, 43).addBox(1.0f, -9.0f, 14.01f, 14.0f, 14.0f, 0.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDoubleBodyRightLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(BOTTOM, CubeListBuilder.create().texOffs(0, 19).addBox(1.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild(LID, CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.addOrReplaceChild(LOCK, CubeListBuilder.create().texOffs(0, 0).addBox(15.0f, -2.0f, 14.0f, 1.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.addOrReplaceChild(Latch, CubeListBuilder.create().texOffs(0, 5).addBox(14.0f, -1.0f, 14.0f, 4.0f, 2.0f, 1.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.addOrReplaceChild(HANDLE, CubeListBuilder.create().texOffs(0, 43).addBox(1.0f, -9.0f, 14.01f, 15.0f, 14.0f, 0.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDoubleBodyLeftLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(BOTTOM, CubeListBuilder.create().texOffs(0, 19).addBox(0.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild(LID, CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.addOrReplaceChild(LOCK, CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -2.0f, 14.0f, 1.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.addOrReplaceChild(HANDLE, CubeListBuilder.create().texOffs(0, 43).addBox(0.0f, -9.0f, 14.01f, 15.0f, 14.0f, 0.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(T pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        Level level = pBlockEntity.getLevel();
        boolean flag = level != null;
        BlockState blockstate = flag ? pBlockEntity.getBlockState() : (BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.SOUTH);
        ChestType chesttype = blockstate.hasProperty((Property)ChestBlock.TYPE) ? (ChestType)blockstate.getValue((Property)ChestBlock.TYPE) : ChestType.SINGLE;
        Block block = blockstate.getBlock();
        Item item = pBlockEntity.getBlockState().getBlock().asItem();
        if (block instanceof AbstractChestBlock) {
            AbstractChestBlock abstractchestblock = (AbstractChestBlock)block;
            boolean flag1 = chesttype != ChestType.SINGLE;
            pPoseStack.pushPose();
            float f = ((Direction)blockstate.getValue((Property)ChestBlock.FACING)).toYRot();
            pPoseStack.translate(0.5f, 0.5f, 0.5f);
            pPoseStack.mulPose(Axis.YP.rotationDegrees(-f));
            pPoseStack.translate(-0.5f, -0.5f, -0.5f);
            DoubleBlockCombiner.NeighborCombineResult neighborcombineresult = flag ? abstractchestblock.combine(blockstate, level, pBlockEntity.getBlockPos(), true) : DoubleBlockCombiner.Combiner::acceptNone;
            float f1 = ((Float2FloatFunction)neighborcombineresult.apply(ChestBlock.opennessCombiner((LidBlockEntity)((LidBlockEntity)pBlockEntity)))).get(pPartialTick);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            int i = ((Int2IntFunction)neighborcombineresult.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(pPackedLight);
            String chestName = item instanceof ChestBlockItem ? ((ChestBlockItem)item).getChestName() : (block instanceof CWTrappedChestBlock ? ((CWTrappedChestBlock)block).getChestName() : ((CWChestBlock)block).getChestName());
            Material material = this.getMaterial(chestName, pBlockEntity, chesttype);
            VertexConsumer vertexconsumer = material.buffer(pBuffer, RenderType::entityCutout);
            if (flag1) {
                if (chesttype == ChestType.LEFT) {
                    this.render(pPoseStack, vertexconsumer, this.doubleLeftLid, this.doubleLeftLock, this.doubleLatch, this.doubleLeftHandle, this.doubleLeftBottom, f1, i, pPackedOverlay, true);
                } else {
                    this.render(pPoseStack, vertexconsumer, this.doubleRightLid, this.doubleRightLock, this.doubleLatch, this.doubleRightHandle, this.doubleRightBottom, f1, i, pPackedOverlay, false);
                }
            } else {
                this.render(pPoseStack, vertexconsumer, this.lid, this.lock, this.latch, this.handle, this.bottom, f1, i, pPackedOverlay, false);
            }
            pPoseStack.popPose();
        }
    }

    private void render(PoseStack pPoseStack, VertexConsumer pConsumer, ModelPart pLidPart, ModelPart pLockPart, ModelPart platchPart, ModelPart pHandlePart, ModelPart pBottomPart, float pLidAngle, int pPackedLight, int pPackedOverlay, Boolean isLeft) {
        pLockPart.xRot = pLidPart.xRot = -(pLidAngle * 1.5707964f);
        if (!isLeft.booleanValue()) {
            platchPart.xRot = pLidPart.xRot;
        }
        pHandlePart.xRot = pLidPart.xRot;
        pLidPart.render(pPoseStack, pConsumer, pPackedLight, pPackedOverlay);
        pLockPart.render(pPoseStack, pConsumer, pPackedLight, pPackedOverlay);
        if (!isLeft.booleanValue()) {
            platchPart.render(pPoseStack, pConsumer, pPackedLight, pPackedOverlay);
        }
        pHandlePart.render(pPoseStack, pConsumer, pPackedLight, pPackedOverlay);
        pBottomPart.render(pPoseStack, pConsumer, pPackedLight, pPackedOverlay);
    }

    protected Material getMaterial(String chestName, T blockEntity, ChestType chestType) {
        return ChestSheets.chooseMaterial(chestName, blockEntity, chestType, this.xmasTextures);
    }
}

