/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.carved_wood.common.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class StrippableLogBlock
extends RotatedPillarBlock {
    private final Boolean isFlammable;

    public StrippableLogBlock(BlockBehaviour.Properties pProperties, Boolean isFlammable) {
        super(pProperties);
        this.isFlammable = isFlammable;
    }

    public StrippableLogBlock(BlockBehaviour.Properties pProperties) {
        this(pProperties, true);
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.isFlammable != false ? 5 : super.getFlammability(state, level, pos, direction);
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.isFlammable != false ? 5 : super.getFlammability(state, level, pos, direction);
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (player.getItemInHand(interactionHand).getItem() instanceof AxeItem) {
            Block block = blockState.getBlock();
            ResourceLocation blockString = BuiltInRegistries.BLOCK.getKey((Object)block);
            String fullPath = blockString.getPath();
            String[] parts = fullPath.split("\\.");
            String lastPart = parts[parts.length - 1];
            String strippedBlockString = "stripped_" + lastPart;
            Block strippedBlock = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)blockString.getNamespace(), (String)strippedBlockString));
            level.playSound(player, blockPos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.setBlockAndUpdate(blockPos, strippedBlock.withPropertiesOf(blockState));
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

