/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.carved_wood.common.block.custom.chiseled_bookshelf;

import java.util.Optional;
import java.util.OptionalInt;
import net.im_maker.carved_wood.common.block.custom.chiseled_bookshelf.CWChiseledBookShelfBlockType1;
import net.im_maker.carved_wood.common.block.entity.custom.CWChiseledBookShelfBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class CWChiseledBookShelfBlockType6
extends CWChiseledBookShelfBlockType1 {
    public CWChiseledBookShelfBlockType6(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof ChiseledBookShelfBlockEntity) {
            ChiseledBookShelfBlockEntity chiseledbookshelfblockentity = (ChiseledBookShelfBlockEntity)blockEntity;
            if (!itemStack.is(ItemTags.BOOKSHELF_BOOKS)) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            OptionalInt optionalint = this.getHitSlot(blockHitResult, blockState);
            if (optionalint.isEmpty()) {
                return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
            }
            if (((Boolean)blockState.getValue((Property)SLOT_OCCUPIED_PROPERTIES.get(optionalint.getAsInt()))).booleanValue()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            CWChiseledBookShelfBlockType6.addBook(level, blockPos, player, chiseledbookshelfblockentity, itemStack, optionalint.getAsInt());
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof ChiseledBookShelfBlockEntity) {
            ChiseledBookShelfBlockEntity chiseledbookshelfblockentity = (ChiseledBookShelfBlockEntity)blockEntity;
            OptionalInt optionalint = this.getHitSlot(blockHitResult, blockState);
            if (optionalint.isEmpty()) {
                return InteractionResult.PASS;
            }
            if (!((Boolean)blockState.getValue((Property)SLOT_OCCUPIED_PROPERTIES.get(optionalint.getAsInt()))).booleanValue()) {
                return InteractionResult.CONSUME;
            }
            CWChiseledBookShelfBlockType6.removeBook(level, blockPos, player, chiseledbookshelfblockentity, optionalint.getAsInt());
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    private static Optional<Vec2> getRelativeHitCoordinatesForBlockFace(BlockHitResult pHitResult, Direction pFace) {
        Direction direction = pHitResult.getDirection();
        if (pFace != direction) {
            return Optional.empty();
        }
        BlockPos blockpos = pHitResult.getBlockPos().relative(direction);
        Vec3 vec3 = pHitResult.getLocation().subtract((double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ());
        double d0 = vec3.x();
        double d1 = vec3.y();
        double d2 = vec3.z();
        return switch (direction) {
            case Direction.NORTH -> Optional.of(new Vec2((float)(1.0 - d0), (float)d1));
            case Direction.SOUTH -> Optional.of(new Vec2((float)d0, (float)d1));
            case Direction.WEST -> Optional.of(new Vec2((float)d2, (float)d1));
            case Direction.EAST -> Optional.of(new Vec2((float)(1.0 - d2), (float)d1));
            case Direction.DOWN, Direction.UP -> Optional.empty();
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private static void removeBook(Level pLevel, BlockPos pPos, Player pPlayer, ChiseledBookShelfBlockEntity pBlockEntity, int pSlot) {
        if (!pLevel.isClientSide) {
            ItemStack itemstack = pBlockEntity.removeItem(pSlot, 1);
            SoundEvent soundevent = itemstack.is(Items.ENCHANTED_BOOK) ? SoundEvents.CHISELED_BOOKSHELF_PICKUP_ENCHANTED : SoundEvents.CHISELED_BOOKSHELF_PICKUP;
            pLevel.playSound((Player)null, pPos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!pPlayer.getInventory().add(itemstack)) {
                pPlayer.drop(itemstack, false);
            }
            pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.BLOCK_CHANGE, pPos);
        }
    }

    private static void addBook(Level pLevel, BlockPos pPos, Player pPlayer, ChiseledBookShelfBlockEntity pBlockEntity, ItemStack pBookStack, int pSlot) {
        if (!pLevel.isClientSide) {
            pPlayer.awardStat(Stats.ITEM_USED.get((Object)pBookStack.getItem()));
            SoundEvent soundevent = pBookStack.is(Items.ENCHANTED_BOOK) ? SoundEvents.CHISELED_BOOKSHELF_INSERT_ENCHANTED : SoundEvents.CHISELED_BOOKSHELF_INSERT;
            pBlockEntity.setItem(pSlot, pBookStack.split(1));
            pLevel.playSound((Player)null, pPos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (pPlayer.isCreative()) {
                pBookStack.grow(1);
            }
            pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.BLOCK_CHANGE, pPos);
        }
    }

    private OptionalInt getHitSlot(BlockHitResult hitResult, BlockState blockState) {
        return CWChiseledBookShelfBlockType6.getRelativeHitCoordinatesForBlockFace(hitResult, (Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING)).map(vec2 -> {
            int i = vec2.y >= CWChiseledBookShelfBlockType6.getBlockPixel(Float.valueOf(5.0f)).floatValue() ? (vec2.y >= CWChiseledBookShelfBlockType6.getBlockPixel(Float.valueOf(10.0f)).floatValue() ? 0 : 2) : 4;
            int j = CWChiseledBookShelfBlockType6.getSection(vec2.x, i);
            return OptionalInt.of(i + j);
        }).orElseGet(OptionalInt::empty);
    }

    private static int getSection(float pX, float pY) {
        if (pX < CWChiseledBookShelfBlockType6.getBlockPixel(Float.valueOf(9.0f)).floatValue()) {
            return 0;
        }
        return 1;
    }

    private static Float getBlockPixel(Float f) {
        return Float.valueOf(f.floatValue() / 16.0f);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new CWChiseledBookShelfBlockEntity(blockPos, blockState);
    }
}

