/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.carved_wood.common.item.custom;

import java.util.function.Consumer;
import net.im_maker.carved_wood.client.renderer.inventory.CWBlockEntityWithoutLevelRenderer;
import net.im_maker.carved_wood.common.block.custom.CWChestBlock;
import net.im_maker.carved_wood.common.block.custom.CWTrappedChestBlock;
import net.im_maker.carved_wood.common.block.entity.custom.CWChestBlockEntity;
import net.im_maker.carved_wood.common.block.entity.custom.CWTrappedChestBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

public class ChestBlockItem
extends BlockItem {
    private Block block;
    private Boolean trapped;
    private final String chestName;
    private int burnTime = 0;

    public ChestBlockItem(Block pBlock, Item.Properties pProperties, Boolean trapped, int burnTime) {
        super(pBlock, pProperties);
        this.block = pBlock;
        this.trapped = trapped;
        this.chestName = this.block instanceof CWTrappedChestBlock ? ((CWTrappedChestBlock)this.block).getChestName() : ((CWChestBlock)this.block).getChestName();
        this.burnTime = burnTime;
    }

    public String getChestName() {
        return this.chestName;
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        return this.burnTime;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                Object be = ChestBlockItem.this.trapped != false ? new CWTrappedChestBlockEntity(BlockPos.ZERO, ChestBlockItem.this.block.defaultBlockState()) : new CWChestBlockEntity(BlockPos.ZERO, ChestBlockItem.this.block.defaultBlockState());
                return new CWBlockEntityWithoutLevelRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels(), (BlockEntity)be);
            }
        });
    }
}

