/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.carved_wood.common.recipe.custom;

import net.im_maker.carved_wood.common.recipe.CWRecipes;
import net.im_maker.carved_wood.common.util.CWTags;
import net.minecraft.core.HolderLookup;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CraftingTableRecipe
extends CustomRecipe {
    public CraftingTableRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        if (craftingInput.width() == 2 && craftingInput.height() == 2) {
            return this.isPlanks(craftingInput.getItem(0)) && this.isPlanks(craftingInput.getItem(1)) && this.isPlanks(craftingInput.getItem(2)) && this.isPlanks(craftingInput.getItem(3));
        }
        if (craftingInput.width() == 3 && craftingInput.height() == 3) {
            return this.checkQuadrant(craftingInput, 0, 1, 3, 4) || this.checkQuadrant(craftingInput, 1, 2, 4, 5) || this.checkQuadrant(craftingInput, 3, 4, 6, 7) || this.checkQuadrant(craftingInput, 4, 5, 7, 8);
        }
        return false;
    }

    private boolean checkQuadrant(CraftingInput craftingInput, int slot1, int slot2, int slot3, int slot4) {
        if (!this.allSlotsArePlanks(craftingInput, slot1, slot2, slot3, slot4)) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            if (i == slot1 || i == slot2 || i == slot3 || i == slot4 || craftingInput.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean allSlotsArePlanks(CraftingInput craftingInput, int ... slots) {
        for (int slot : slots) {
            if (this.isPlanks(craftingInput.getItem(slot))) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        return new ItemStack((ItemLike)Items.CRAFTING_TABLE);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)CWRecipes.CRAFTING_TABLE.get();
    }

    private boolean isPlanks(ItemStack stack) {
        return stack.is(ItemTags.PLANKS) && !stack.is(CWTags.Items.FLAG);
    }
}

