/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.carved_wood.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.im_maker.carved_wood.common.block.custom.CWBarrelBlock;
import net.im_maker.carved_wood.common.block.custom.CWBeehiveBlock;
import net.im_maker.carved_wood.common.block.custom.CWLecternBlock;
import net.im_maker.carved_wood.common.util.CWTags;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class CWPoiType {
    public static final DeferredRegister<PoiType> POI_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"carved_wood");
    public static final RegistryObject<PoiType> BEEHIVE = POI_TYPES.register("beehive", () -> new PoiType(CWPoiType.getPOIBeehive(), 1, 1));

    public static void init() {
        Map poiStatesToType = GameData.PoiTypeCallbacks.getStateToPoi();
        PoiType fishermanPoiType = (PoiType)BuiltInRegistries.POINT_OF_INTEREST_TYPE.get(PoiTypes.FISHERMAN.location());
        PoiType librarianPoiType = (PoiType)BuiltInRegistries.POINT_OF_INTEREST_TYPE.get(PoiTypes.LIBRARIAN.location());
        PoiType beehivePoiType = (PoiType)BuiltInRegistries.POINT_OF_INTEREST_TYPE.get(PoiTypes.BEEHIVE.location());
        ArrayList<BlockState> fishermanBlockStates = new ArrayList<BlockState>(fishermanPoiType.matchingStates());
        ArrayList<BlockState> librarianBlockStates = new ArrayList<BlockState>(librarianPoiType.matchingStates());
        ArrayList<BlockState> beehiveBlockStates = new ArrayList<BlockState>(beehivePoiType.matchingStates());
        for (Block block : BuiltInRegistries.BLOCK) {
            ArrayList<BlockState> blockStates;
            if (CWPoiType.isInBarrels(block)) {
                blockStates = new ArrayList<BlockState>(CWPoiType.getPOIFisherman());
                for (BlockState blockState : blockStates) {
                    poiStatesToType.putIfAbsent(blockState, BuiltInRegistries.POINT_OF_INTEREST_TYPE.wrapAsHolder((Object)fishermanPoiType));
                }
                fishermanBlockStates.addAll(blockStates);
            }
            if (CWPoiType.isInLectern(block)) {
                blockStates = new ArrayList<BlockState>(CWPoiType.getPOILibrarian());
                for (BlockState blockState : blockStates) {
                    poiStatesToType.putIfAbsent(blockState, BuiltInRegistries.POINT_OF_INTEREST_TYPE.wrapAsHolder((Object)librarianPoiType));
                }
                librarianBlockStates.addAll(blockStates);
            }
            if (!CWPoiType.isInBeehive(block)) continue;
            blockStates = new ArrayList<BlockState>(CWPoiType.getPOIBeehive());
            for (BlockState blockState : blockStates) {
                poiStatesToType.putIfAbsent(blockState, BuiltInRegistries.POINT_OF_INTEREST_TYPE.wrapAsHolder((Object)beehivePoiType));
            }
            beehiveBlockStates.addAll(blockStates);
        }
    }

    private static Set<BlockState> getPOILibrarian() {
        HashSet<BlockState> states = new HashSet<BlockState>();
        BuiltInRegistries.BLOCK.stream().filter(CWPoiType::isInLectern).forEach(CWPoiType.addAllBlockStates(states));
        return states;
    }

    private static Set<BlockState> getPOIFisherman() {
        HashSet<BlockState> states = new HashSet<BlockState>();
        BuiltInRegistries.BLOCK.stream().filter(CWPoiType::isInBarrels).forEach(CWPoiType.addAllBlockStates(states));
        return states;
    }

    private static Set<BlockState> getPOIBeehive() {
        HashSet<BlockState> states = new HashSet<BlockState>();
        BuiltInRegistries.BLOCK.stream().filter(CWPoiType::isInBeehive).forEach(CWPoiType.addAllBlockStates(states));
        return states;
    }

    private static boolean isInBarrels(Block block) {
        return block instanceof CWBarrelBlock || block.defaultBlockState().is(Tags.Blocks.BARRELS_WOODEN);
    }

    private static boolean isInLectern(Block block) {
        return block instanceof CWLecternBlock || block == Blocks.LECTERN || block.defaultBlockState().is(CWTags.Blocks.LECTERNS);
    }

    private static boolean isInBeehive(Block block) {
        return block instanceof CWBeehiveBlock;
    }

    @NotNull
    private static Consumer<Block> addAllBlockStates(Set<BlockState> states) {
        return block -> states.addAll((Collection<BlockState>)block.getStateDefinition().getPossibleStates());
    }

    public static void register(IEventBus eventBus) {
        POI_TYPES.register(eventBus);
    }
}

