/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.carved_wood.datagen;

import java.util.concurrent.CompletableFuture;
import net.im_maker.carved_wood.CarvedWood;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public ModRecipeProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, pRegistries);
    }

    private Item item(String string) {
        return CarvedWood.getItemFromString(string);
    }

    private Block block(String string) {
        return CarvedWood.getBlockFromString(string);
    }

    private Item item(String id, String string) {
        return CarvedWood.getItemFromString(id, string);
    }

    private Block block(String id, String string) {
        return CarvedWood.getBlockFromString(id, string);
    }

    private void LargePlanksRecipe(RecipeOutput output, String woodType) {
        Item ingredient = this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + "_planks");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)this.item(woodType + "_panels"), (int)9).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)ingredient).group("wooden_panels").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).save(output);
    }

    private void woodenBoardsRecipe(RecipeOutput output, String woodType) {
        Item ingredient = this.item(woodType + "_panels");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)this.item(woodType + "_boards"), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)ingredient).group("wooden_boards").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).save(output);
    }

    private void woodenSmoothBoardsRecipe(RecipeOutput output, String woodType) {
        Item ingredient = this.item(woodType + "_boards");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)this.item("smooth_" + woodType + "_boards"), (int)9).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)ingredient).group("wooden_smooth_boards").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).save(output);
    }

    private void woodenTilesRecipe(RecipeOutput output, String woodType) {
        Item ingredient = this.item(woodType + "_boards");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)this.item(woodType + "_tiles"), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)ingredient).group("wooden_tiles").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).save(output);
    }

    private void woodenTileStairsRecipe(RecipeOutput output, String woodType) {
        Item ingredient = this.item(woodType + "_tiles");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)this.item(woodType + "_tile_stairs"), (int)4).pattern("#  ").pattern("## ").pattern("###").define(Character.valueOf('#'), (ItemLike)ingredient).group("wooden_tile_stairs").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).save(output);
    }

    private void woodenTileSlabsRecipe(RecipeOutput output, String woodType) {
        Item ingredient = this.item(woodType + "_tiles");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)this.item(woodType + "_tile_slab"), (int)6).pattern("###").define(Character.valueOf('#'), (ItemLike)ingredient).group("wooden_tile_slab").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).save(output);
    }

    private void woodenMosaicRecipe(RecipeOutput output, String woodType) {
        Item ingredient = this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + "_slab");
        Item result = woodType == "bamboo" ? Blocks.BAMBOO_MOSAIC.asItem() : this.item(woodType + "_mosaic");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)1).pattern("#").pattern("#").define(Character.valueOf('#'), (ItemLike)ingredient).group("wooden_mosaic").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).save(output);
    }

    private void woodenMosaicStairsRecipe(RecipeOutput output, String woodType) {
        Item ingredient = woodType == "bamboo" ? Blocks.BAMBOO_MOSAIC.asItem() : this.item(woodType + "_mosaic");
        Item result = woodType == "bamboo" ? Blocks.BAMBOO_MOSAIC_STAIRS.asItem() : this.item(woodType + "_mosaic_stairs");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)4).pattern("#  ").pattern("## ").pattern("###").define(Character.valueOf('#'), (ItemLike)ingredient).group("wooden_mosaic_stairs").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).save(output);
    }

    private void woodenMosaicSlabsRecipe(RecipeOutput output, String woodType) {
        Item ingredient = woodType == "bamboo" ? Blocks.BAMBOO_MOSAIC.asItem() : this.item(woodType + "_mosaic");
        Item result = woodType == "bamboo" ? Blocks.BAMBOO_MOSAIC_SLAB.asItem() : this.item(woodType + "_mosaic_slab");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)6).pattern("###").define(Character.valueOf('#'), (ItemLike)ingredient).group("wooden_mosaic_slab").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).save(output);
    }

    private void carvedPlanksRecipe(RecipeOutput output, String woodType) {
        Item ingredient = this.item(woodType + "_tile_slab");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)this.item("carved_" + woodType + "_planks"), (int)1).pattern("#").pattern("#").define(Character.valueOf('#'), (ItemLike)ingredient).group("carved_planks").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).save(output);
    }

    private void woodenLanternRecipe(RecipeOutput output, String woodType) {
        Item ingredient = this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + "_planks");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)this.item(woodType + "_lantern"), (int)2).pattern(" # ").pattern("PSP").pattern(" # ").define(Character.valueOf('#'), (ItemLike)ingredient).define(Character.valueOf('P'), (ItemLike)Items.PAPER).define(Character.valueOf('S'), (ItemLike)Items.SHROOMLIGHT).group("wooden_lantern").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.SHROOMLIGHT), ModRecipeProvider.has((ItemLike)Items.SHROOMLIGHT)).save(output);
    }

    private void woodenLanternBlockRecipe(RecipeOutput output, String woodType) {
        Item ingredient = this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + "_planks");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)this.item(woodType + "_lantern_block"), (int)2).pattern("#P#").pattern("PSP").pattern("#P#").define(Character.valueOf('#'), (ItemLike)ingredient).define(Character.valueOf('P'), (ItemLike)Items.PAPER).define(Character.valueOf('S'), (ItemLike)Items.SHROOMLIGHT).group("wooden_lantern_block").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.SHROOMLIGHT), ModRecipeProvider.has((ItemLike)Items.SHROOMLIGHT)).save(output);
    }

    private void woodenLanternFromWoodenLanternBlockRecipe(RecipeOutput output, String woodType) {
        Item ingredient = this.item(woodType + "_lantern_block");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)this.item(woodType + "_lantern"), (int)2).requires((ItemLike)ingredient).group("wooden_lantern_from_wooden_lantern_block").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).save(output, "carved_wood:" + woodType + "_lantern_from_" + woodType + "_lantern_block");
    }

    private void woodenLanternBlockFromWoodenLanternRecipe(RecipeOutput output, String woodType) {
        Item ingredient = this.item(woodType + "_lantern");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)this.item(woodType + "_lantern_block"), (int)1).requires((ItemLike)ingredient).requires((ItemLike)ingredient).group("wooden_lantern_block_from_wooden_lantern").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).save(output, "carved_wood:" + woodType + "_lantern_block_from_" + woodType + "_lantern");
    }

    private void woodenPillarsRecipe(RecipeOutput output, String woodType) {
        Item ingredient = this.item(woodType + "_boards");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)this.item(woodType + "_pillar"), (int)2).pattern("#").pattern("#").define(Character.valueOf('#'), (ItemLike)ingredient).group("wooden_pillar").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).save(output);
    }

    private void woodenCampfiresRecipe(RecipeOutput output, String woodType) {
        Item ingredient0 = this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + (switch (woodType) {
            case "crimson", "warped" -> "_stem";
            case "bamboo" -> "_block";
            default -> "_log";
        }));
        Item ingredient1 = this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + trunkWoodType);
        Item result = this.item(woodType + "_campfire");
        result = woodType == "oak" ? Blocks.CAMPFIRE.asItem() : result;
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result, (int)1).pattern(" S ").pattern("SCS").pattern("###").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('C'), ItemTags.COALS).define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{ingredient0, ingredient1})).group("campfires").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.STICK), ModRecipeProvider.has((TagKey)Tags.Items.RODS)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.COAL), ModRecipeProvider.has((TagKey)ItemTags.COALS)).save(output);
    }

    private void woodenSoulCampfiresRecipe(RecipeOutput output, String woodType) {
        Item ingredient0 = this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + (switch (woodType) {
            case "crimson", "warped" -> "_stem";
            case "bamboo" -> "_block";
            default -> "_log";
        }));
        Item ingredient1 = this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + trunkWoodType);
        Item result = this.item("soul_" + woodType + "_campfire");
        result = woodType == "oak" ? Blocks.SOUL_CAMPFIRE.asItem() : result;
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result, (int)1).pattern(" S ").pattern("SCS").pattern("###").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('C'), ItemTags.SOUL_FIRE_BASE_BLOCKS).define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{ingredient0, ingredient1})).group("campfires").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.STICK), ModRecipeProvider.has((TagKey)Tags.Items.RODS)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.COAL), ModRecipeProvider.has((TagKey)ItemTags.COALS)).save(output);
    }

    private void logBundlesRecipe(RecipeOutput output, String woodType) {
        String trunkType = switch (woodType) {
            case "crimson", "warped" -> "_stem";
            case "bamboo" -> "_block";
            default -> "_log";
        };
        Item ingredient = this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + trunkType);
        trunkType = trunkType == "_block" ? "" : trunkType;
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)this.item(woodType + trunkType + "_bundle"), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)ingredient).group("log_bundle").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).save(output);
    }

    private void strippedLogBundlesRecipe(RecipeOutput output, String woodType) {
        String trunkType = switch (woodType) {
            case "crimson", "warped" -> "_stem";
            case "bamboo" -> "_block";
            default -> "_log";
        };
        Item ingredient = this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", "stripped_" + woodType + trunkType);
        trunkType = trunkType == "_block" ? "" : trunkType;
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)this.item("stripped_" + woodType + trunkType + "_bundle"), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)ingredient).group("log_bundle").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).save(output);
    }

    private void logsFromLogsBundlesRecipes(RecipeOutput output, String woodType) {
        String trunkType = switch (woodType) {
            case "crimson", "warped" -> "_stem";
            case "bamboo" -> "";
            default -> "_log";
        };
        Item ingredient = this.item(woodType + trunkType + "_bundle");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + (trunkType == "" ? "_block" : trunkType)), (int)1).requires((ItemLike)ingredient).group("logs").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).save(output, "carved_wood:" + woodType + trunkType + "_from_" + woodType + trunkType + "_bundle");
    }

    private void strippedLogsFromStrippedLogBundlesRecipes(RecipeOutput output, String woodType) {
        String trunkType = switch (woodType) {
            case "crimson", "warped" -> "_stem";
            case "bamboo" -> "";
            default -> "_log";
        };
        Item ingredient = this.item("stripped_" + woodType + trunkType + "_bundle");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", "stripped_" + woodType + (trunkType == "" ? "_block" : trunkType)), (int)1).requires((ItemLike)ingredient).group("log").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).save(output, "carved_wood:stripped_" + woodType + trunkType + "_from_stripped_" + woodType + trunkType + "_bundle");
    }

    private void woodsFromLogsRecipes(RecipeOutput output, String woodType) {
        if (woodType != "bamboo") {
            Item ingredient = this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + (switch (woodType) {
                case "crimson", "warped" -> "_stem";
                default -> "_log";
            }));
            Item result = this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + barkType);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)5).pattern(" # ").pattern("###").pattern(" # ").define(Character.valueOf('#'), (ItemLike)ingredient).group("bark").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).save(output);
        }
    }

    private void strippedWoodsFromStrippedLogsRecipes(RecipeOutput output, String woodType) {
        if (woodType != "bamboo") {
            Item ingredient = this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", "stripped_" + woodType + (switch (woodType) {
                case "crimson", "warped" -> "_stem";
                default -> "_log";
            }));
            Item result = this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", "stripped_" + woodType + barkType);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)5).pattern(" # ").pattern("###").pattern(" # ").define(Character.valueOf('#'), (ItemLike)ingredient).group("bark").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).save(output);
        }
    }

    private void woodenCraftingTables(RecipeOutput output, String woodType) {
        Item ingredient = this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + "_planks");
        Item result = this.item(woodType + "_crafting_table");
        result = woodType == "oak" ? Blocks.CRAFTING_TABLE.asItem() : result;
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result, (int)1).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)ingredient).group("crafting_table").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).save(output);
    }

    private void woodenLadders(RecipeOutput output, String woodType) {
        Item ingredient = this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + "_planks");
        Item result = this.item(woodType + "_ladder");
        result = woodType == "oak" ? Blocks.LADDER.asItem() : result;
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result, (int)3).pattern("S S").pattern("S#S").pattern("S S").define(Character.valueOf('#'), (ItemLike)ingredient).define(Character.valueOf('S'), (ItemLike)Items.STICK).group("ladder").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).save(output);
    }

    private void woodenChests(RecipeOutput output, String woodType) {
        Item ingredient = this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + "_planks");
        Item result = this.item(woodType + "_chest");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result, (int)1).pattern("###").pattern("# #").pattern("###").define(Character.valueOf('#'), (ItemLike)ingredient).group("chest").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).save(output);
    }

    private void woodenTrappedChests(RecipeOutput output, String woodType) {
        Item ingredient = this.item(woodType + "_chest");
        Item result = this.item("trapped_" + woodType + "_chest");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result, (int)1).requires((ItemLike)ingredient).requires((ItemLike)Items.TRIPWIRE_HOOK).group("trapped_chest").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).save(output);
    }

    private void woodenBarrels(RecipeOutput output, String woodType) {
        Item planks = this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + "_planks");
        Item slab = this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + "_slab");
        Item result = this.item(woodType + "_barrel");
        result = woodType == "spruce" ? Blocks.BARREL.asItem() : result;
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result, (int)1).pattern("PSP").pattern("P P").pattern("PSP").define(Character.valueOf('P'), (ItemLike)planks).define(Character.valueOf('S'), (ItemLike)slab).group("barrel").unlockedBy(ModRecipeProvider.getHasName((ItemLike)planks), ModRecipeProvider.has((ItemLike)planks)).save(output);
    }

    private void woodenBookshelves(RecipeOutput output, String woodType) {
        Item planks = this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + "_planks");
        Item result = this.item(woodType + "_bookshelf");
        result = woodType == "oak" ? Blocks.BOOKSHELF.asItem() : result;
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result, (int)1).pattern("PPP").pattern("BBB").pattern("PPP").define(Character.valueOf('P'), (ItemLike)planks).define(Character.valueOf('B'), (ItemLike)Items.BOOK).group("bookshelf").unlockedBy(ModRecipeProvider.getHasName((ItemLike)planks), ModRecipeProvider.has((ItemLike)planks)).save(output);
    }

    private void woodenChiseledBookshelves(RecipeOutput output, String woodType) {
        Item planks = this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + "_planks");
        Item slab = this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + "_slab");
        Item result = this.item("chiseled_" + woodType + "_bookshelf");
        result = woodType == "oak" ? Blocks.CHISELED_BOOKSHELF.asItem() : result;
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)1).pattern("PPP").pattern("SSS").pattern("PPP").define(Character.valueOf('P'), (ItemLike)planks).define(Character.valueOf('S'), (ItemLike)slab).group("chiseled_bookshelf").unlockedBy(ModRecipeProvider.getHasName((ItemLike)planks), ModRecipeProvider.has((ItemLike)planks)).save(output);
    }

    private void woodenLecterns(RecipeOutput output, String woodType) {
        Item slab = this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + "_slab");
        Item bookshelf = this.item(woodType + "_bookshelf");
        Item result = this.item(woodType + "_lectern");
        result = woodType == "oak" ? Blocks.LECTERN.asItem() : result;
        bookshelf = woodType == "oak" ? Blocks.BOOKSHELF.asItem() : bookshelf;
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)result, (int)1).pattern("SSS").pattern(" B ").pattern(" S ").define(Character.valueOf('S'), (ItemLike)slab).define(Character.valueOf('B'), (ItemLike)bookshelf).group("lectern").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.BOOK), ModRecipeProvider.has((ItemLike)Items.BOOK)).save(output);
    }

    private void woodenBeehives(RecipeOutput output, String woodType) {
        Item planks = this.item(!woodType.equals("pale_oak") ? "minecraft" : "vanillabackport", woodType + "_planks");
        Item honeycomb = Items.HONEYCOMB;
        Item result = this.item(woodType + "_beehive");
        result = woodType == "oak" ? Blocks.BEEHIVE.asItem() : result;
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result, (int)1).pattern("PPP").pattern("###").pattern("PPP").define(Character.valueOf('P'), (ItemLike)planks).define(Character.valueOf('#'), (ItemLike)honeycomb).group("beehive").unlockedBy(ModRecipeProvider.getHasName((ItemLike)honeycomb), ModRecipeProvider.has((ItemLike)honeycomb)).save(output);
    }

    private void woodenCrafters(RecipeOutput output, String woodType) {
        if (woodType.equals("oak")) {
            return;
        }
        Item crafting_table = this.item(woodType + "_crafting_table");
        Item iron = Items.IRON_INGOT;
        Item redstone = Items.REDSTONE;
        Item dropper = Items.DROPPER;
        Item result = this.item(woodType + "_crafter");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)result, (int)1).pattern("III").pattern("ICI").pattern("RDR").define(Character.valueOf('I'), (ItemLike)iron).define(Character.valueOf('R'), (ItemLike)redstone).define(Character.valueOf('C'), (ItemLike)crafting_table).define(Character.valueOf('D'), (ItemLike)dropper).group("beehive").unlockedBy(ModRecipeProvider.getHasName((ItemLike)dropper), ModRecipeProvider.has((ItemLike)dropper)).save(output);
    }

    private void vanillaTrappedChest(RecipeOutput output) {
        Item ingredient = Items.CHEST;
        Item result = Items.TRAPPED_CHEST;
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result, (int)1).requires((ItemLike)ingredient).requires((ItemLike)Items.TRIPWIRE_HOOK).group("trapped_chest").unlockedBy(ModRecipeProvider.getHasName((ItemLike)ingredient), ModRecipeProvider.has((ItemLike)ingredient)).save(output);
    }

    private void removingTheChestRecipe(RecipeOutput output) {
        Item result = Items.CHEST;
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result, (int)1).unlockedBy(ModRecipeProvider.getHasName((ItemLike)result), ModRecipeProvider.has((ItemLike)result)).save(output);
    }

    private void chestFromTag(RecipeOutput output) {
        TagKey ingredient = Tags.Items.CHESTS_WOODEN;
        Item result = Items.CHEST;
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result, (int)1).requires(ingredient).unlockedBy(ModRecipeProvider.getHasName((ItemLike)result), ModRecipeProvider.has((TagKey)ingredient)).group("chest").save(output, "chest_from_chest_tag");
    }

    private void trappedChestFromTag(RecipeOutput output) {
        TagKey ingredient = Tags.Items.CHESTS_TRAPPED;
        Item result = Items.TRAPPED_CHEST;
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result, (int)1).requires(ingredient).unlockedBy(ModRecipeProvider.getHasName((ItemLike)result), ModRecipeProvider.has((TagKey)ingredient)).save(output, "trapped_chest_from_trapped_chest_tag");
    }

    protected void buildRecipes(RecipeOutput output) {
        for (String type : CarvedWood.WOOD_TYPES) {
            if (type.equals("pale_oak")) continue;
            this.LargePlanksRecipe(output, type);
            this.woodenBoardsRecipe(output, type);
            this.woodenSmoothBoardsRecipe(output, type);
            this.woodenTilesRecipe(output, type);
            this.woodenTileStairsRecipe(output, type);
            this.woodenTileSlabsRecipe(output, type);
            this.woodenMosaicRecipe(output, type);
            this.woodenMosaicStairsRecipe(output, type);
            this.woodenMosaicSlabsRecipe(output, type);
            this.carvedPlanksRecipe(output, type);
            this.woodenPillarsRecipe(output, type);
            this.woodenLanternRecipe(output, type);
            this.woodenLanternBlockRecipe(output, type);
            this.woodenLanternFromWoodenLanternBlockRecipe(output, type);
            this.woodenLanternBlockFromWoodenLanternRecipe(output, type);
            this.woodenCampfiresRecipe(output, type);
            this.woodenSoulCampfiresRecipe(output, type);
            this.logBundlesRecipe(output, type);
            this.strippedLogBundlesRecipe(output, type);
            this.logsFromLogsBundlesRecipes(output, type);
            this.strippedLogsFromStrippedLogBundlesRecipes(output, type);
            this.woodsFromLogsRecipes(output, type);
            this.strippedWoodsFromStrippedLogsRecipes(output, type);
            this.woodenCraftingTables(output, type);
            this.woodenLadders(output, type);
            this.woodenChests(output, type);
            this.woodenTrappedChests(output, type);
            this.woodenBarrels(output, type);
            this.woodenBookshelves(output, type);
            this.woodenChiseledBookshelves(output, type);
            this.woodenLecterns(output, type);
            this.woodenBeehives(output, type);
            this.woodenCrafters(output, type);
        }
        this.vanillaTrappedChest(output);
        this.removingTheChestRecipe(output);
        this.chestFromTag(output);
        this.trappedChestFromTag(output);
    }
}

