/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.storage.source;

import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockProvider;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.ultramega.refinedtypes.ModInitializer;
import com.ultramega.refinedtypes.RefinedTypesUtil;
import com.ultramega.refinedtypes.registry.BlockEntities;
import com.ultramega.refinedtypes.registry.Menus;
import com.ultramega.refinedtypes.storage.source.SourceStorageVariant;
import com.ultramega.refinedtypes.type.source.SourceResourceFactory;
import com.ultramega.refinedtypes.type.source.SourceResourceType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class SourceStorageBlockProvider
implements StorageBlockProvider {
    private final SourceStorageVariant variant;
    private final Component displayName;

    public SourceStorageBlockProvider(SourceStorageVariant variant) {
        this.variant = variant;
        this.displayName = RefinedTypesUtil.createRefinedTypesTranslation("block", String.format("%s_source_storage_block", variant.getName()));
    }

    public SerializableStorage createStorage(Runnable runnable) {
        return SourceResourceType.STORAGE_TYPE.create(this.variant.getCapacity(), runnable);
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public long getEnergyUsage() {
        return switch (this.variant) {
            default -> throw new MatchException(null, null);
            case SourceStorageVariant.B_64 -> ModInitializer.getConfig().getSourceStorageBlock().get64BSourceUsage();
            case SourceStorageVariant.B_256 -> ModInitializer.getConfig().getSourceStorageBlock().get256BSourceUsage();
            case SourceStorageVariant.B_1024 -> ModInitializer.getConfig().getSourceStorageBlock().get1024BSourceUsage();
            case SourceStorageVariant.B_8192 -> ModInitializer.getConfig().getSourceStorageBlock().get8192BSourceUsage();
            case SourceStorageVariant.B_65536 -> ModInitializer.getConfig().getSourceStorageBlock().get65536BSourceUsage();
            case SourceStorageVariant.B_262144 -> ModInitializer.getConfig().getSourceStorageBlock().get262144BSourceUsage();
            case SourceStorageVariant.B_1048576 -> ModInitializer.getConfig().getSourceStorageBlock().get1048576BSourceUsage();
            case SourceStorageVariant.B_8388608 -> ModInitializer.getConfig().getSourceStorageBlock().get8388608BSourceUsage();
            case SourceStorageVariant.INFINITE -> ModInitializer.getConfig().getSourceStorageBlock().getInfiniteSourceUsage();
        };
    }

    public ResourceFactory getResourceFactory() {
        return SourceResourceFactory.INSTANCE;
    }

    public BlockEntityType<?> getBlockEntityType() {
        return BlockEntities.getSourceStorageBlock(this.variant);
    }

    public MenuType<?> getMenuType() {
        return Menus.getSourceStorage();
    }
}

