/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.type.energy;

import com.refinedmods.refinedstorage.api.core.NullableType;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;

public class EnergyCapabilityCache {
    private final BlockCapabilityCache<ILongEnergyStorage, @NullableType Direction> cache;

    public EnergyCapabilityCache(ServerLevel level, BlockPos pos, Direction direction) {
        this.cache = BlockCapabilityCache.create((BlockCapability)ILongEnergyStorage.BLOCK, (ServerLevel)level, (BlockPos)pos, (Object)direction);
    }

    public Optional<ILongEnergyStorage> getCapability() {
        return Optional.ofNullable((ILongEnergyStorage)this.cache.getCapability());
    }

    public Iterator<ResourceAmount> createAmountIterator() {
        return this.getCapability().map(handler -> {
            long amount = handler.getAmount();
            if (amount > 0L) {
                return Collections.singletonList(new ResourceAmount((ResourceKey)EnergyResource.createEnergyResource(), amount)).iterator();
            }
            return Collections.emptyIterator();
        }).orElse(Collections.emptyListIterator());
    }

    public Iterator<ResourceKey> createIterator() {
        return this.getCapability().map(handler -> {
            long amount = handler.getAmount();
            if (amount > 0L) {
                return Collections.singletonList(EnergyResource.createEnergyResource()).iterator();
            }
            return Collections.emptyListIterator();
        }).orElse(Collections.emptyListIterator());
    }
}

