/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.type.source;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridOperationsImpl;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.storage.StorageType;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.storage.SameTypeStorageType;
import com.ultramega.refinedtypes.RefinedTypesUtil;
import com.ultramega.refinedtypes.registry.Types;
import com.ultramega.refinedtypes.type.source.SourceResource;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public enum SourceResourceType implements ResourceType
{
    INSTANCE;

    public static final MapCodec<SourceResource> MAP_CODEC;
    public static final Codec<SourceResource> CODEC;
    public static final StreamCodec<RegistryFriendlyByteBuf, SourceResource> STREAM_CODEC;
    public static final StorageType STORAGE_TYPE;
    private static final MutableComponent TITLE;
    private static final ResourceLocation SPRITE;

    public MapCodec<PlatformResourceKey> getMapCodec() {
        return MAP_CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, PlatformResourceKey> getStreamCodec() {
        return STREAM_CODEC;
    }

    public MutableComponent getTitle() {
        return TITLE;
    }

    public ResourceLocation getSprite() {
        return SPRITE;
    }

    public long normalizeAmount(double amount) {
        return (long)(amount * (double)Platform.INSTANCE.getBucketAmount());
    }

    public double getDisplayAmount(long amount) {
        return (double)amount / (double)Platform.INSTANCE.getBucketAmount();
    }

    public long getInterfaceExportLimit() {
        return Platform.INSTANCE.getBucketAmount() * 64L;
    }

    public GridOperations createGridOperations(RootStorage rootStorage, Actor actor) {
        return new GridOperationsImpl(rootStorage, actor, resource -> Long.MAX_VALUE, Platform.INSTANCE.getBucketAmount());
    }

    static {
        MAP_CODEC = RecordCodecBuilder.mapCodec(ins -> ins.group((App)Types.CODEC.fieldOf("source").forGetter(SourceResource::type)).apply((Applicative)ins, SourceResource::new));
        CODEC = MAP_CODEC.codec();
        STREAM_CODEC = StreamCodec.composite(Types.STREAM_CODEC, SourceResource::type, SourceResource::new);
        STORAGE_TYPE = new SameTypeStorageType(CODEC, resource -> resource instanceof SourceResource, SourceResource.class::cast, Platform.INSTANCE.getBucketAmount(), Platform.INSTANCE.getBucketAmount() * 64L);
        TITLE = RefinedTypesUtil.createRefinedTypesTranslation("misc", "resource_type.source");
        SPRITE = RefinedTypesUtil.createRefinedTypesIdentifier("source_resource_type");
    }
}

