/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.compat.jei;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.ultramega.refinedtypes.RefinedTypesUtil;
import com.ultramega.refinedtypes.registry.Types;
import com.ultramega.refinedtypes.type.TypeStack;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import com.ultramega.refinedtypes.type.soul.SoulResource;
import com.ultramega.refinedtypes.type.source.SourceResource;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.registration.IModIngredientRegistration;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final IIngredientType<TypeStack> TYPE = () -> TypeStack.class;
    public static final IIngredientHelper<TypeStack> TYPE_HELPER = new IIngredientHelper<TypeStack>(){

        public IIngredientType<TypeStack> getIngredientType() {
            return TYPE;
        }

        public String getDisplayName(TypeStack ingredient) {
            return ingredient.type().getDisplayName().getString();
        }

        public String getUniqueId(TypeStack ingredient, UidContext context) {
            return ingredient.type().name();
        }

        public ResourceLocation getResourceLocation(TypeStack ingredient) {
            return RefinedTypesUtil.createRefinedTypesIdentifier(ingredient.type().name());
        }

        public TypeStack copyIngredient(TypeStack ingredient) {
            return ingredient;
        }

        public String getErrorInfo(@Nullable TypeStack ingredient) {
            return ingredient != null ? ingredient.type().getDisplayName().getString() : "Error";
        }
    };
    public static final IIngredientRenderer<TypeStack> TYPE_RENDER = new IIngredientRenderer<TypeStack>(){

        public void render(GuiGraphics graphics, TypeStack ingredient) {
            if (ingredient.type() == Types.FE.get()) {
                RefinedStorageClientApi.INSTANCE.getResourceRendering(EnergyResource.class).render((ResourceKey)EnergyResource.createEnergyResource(), graphics, 0, 0);
            } else if (ingredient.type() == Types.SOURCE.get()) {
                RefinedStorageClientApi.INSTANCE.getResourceRendering(SourceResource.class).render((ResourceKey)SourceResource.createSourceResource(), graphics, 0, 0);
            } else if (ingredient.type() == Types.SOUL.get()) {
                RefinedStorageClientApi.INSTANCE.getResourceRendering(SoulResource.class).render((ResourceKey)SoulResource.createSoulResource(), graphics, 0, 0);
            }
        }

        public List<Component> getTooltip(TypeStack ingredient, TooltipFlag tooltipFlag) {
            return List.of(ingredient.type().getDisplayName());
        }
    };
    private static final ResourceLocation ID = RefinedTypesUtil.createRefinedTypesIdentifier("plugin");

    public void registerIngredients(IModIngredientRegistration registration) {
        List<TypeStack> types = List.of(new TypeStack(Types.FE.get(), 1L), new TypeStack(Types.SOURCE.get(), 1000L), new TypeStack(Types.SOUL.get(), 1L));
        registration.register(TYPE, types, TYPE_HELPER, TYPE_RENDER, TypeStack.CODEC);
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

