/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.type.energy;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.InsertableStorage;
import com.ultramega.refinedtypes.type.energy.EnergyCapabilityCache;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import dev.technici4n.grandpower.api.ILongEnergyStorage;

public class EnergyInsertableStorage
implements InsertableStorage {
    private final EnergyCapabilityCache capabilityCache;

    public EnergyInsertableStorage(EnergyCapabilityCache capabilityCache) {
        this.capabilityCache = capabilityCache;
    }

    public long getAmount(ResourceKey resource) {
        if (!(resource instanceof EnergyResource)) {
            return 0L;
        }
        return this.capabilityCache.getCapability().map(ILongEnergyStorage::getAmount).orElse(0L);
    }

    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        if (!(resource instanceof EnergyResource)) {
            return 0L;
        }
        return this.capabilityCache.getCapability().map(handler -> handler.receive(amount, action == Action.SIMULATE)).orElse(0L);
    }
}

