/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModList;

public final class RefinedTypesUtil {
    public static final String MOD_ID = "refinedtypes";
    public static final ResourceLocation CREATIVE_MODE_TAB = RefinedTypesUtil.createRefinedTypesIdentifier("refinedtypes");
    public static final MutableComponent MOD = Component.translatable((String)"refinedtypes.configuration.title");
    public static final String ARS_NOUVEAU = "ars_nouveau";
    public static final String INDUSTRIAL_FOREGOING_SOULS = "industrialforegoingsouls";
    @Nullable
    private static Boolean arsNouveauLoaded = null;
    @Nullable
    private static Boolean industrialForegoingSoulsLoaded = null;

    private RefinedTypesUtil() {
    }

    public static ResourceLocation createRefinedTypesIdentifier(String value) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)value);
    }

    public static String createRefinedTypesTranslationKey(String category, String value) {
        return String.format("%s.%s.%s", category, MOD_ID, value);
    }

    public static MutableComponent createRefinedTypesTranslation(String category, String value) {
        return Component.translatable((String)RefinedTypesUtil.createRefinedTypesTranslationKey(category, value));
    }

    public static MutableComponent createRefinedTypesTranslation(String category, String value, Object ... args) {
        return Component.translatable((String)RefinedTypesUtil.createRefinedTypesTranslationKey(category, value), (Object[])args);
    }

    public static boolean isArsNouveauLoaded() {
        if (arsNouveauLoaded == null) {
            arsNouveauLoaded = ModList.get().isLoaded(ARS_NOUVEAU);
        }
        return arsNouveauLoaded;
    }

    public static boolean isIndustrialForegoingSoulsLoaded() {
        if (industrialForegoingSoulsLoaded == null) {
            industrialForegoingSoulsLoaded = ModList.get().isLoaded(INDUSTRIAL_FOREGOING_SOULS);
        }
        return industrialForegoingSoulsLoaded;
    }
}

