/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.grid.energy;

import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepository;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.grid.GridScrollMode;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridExtractionStrategy;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridScrollingStrategy;
import com.refinedmods.refinedstorage.common.api.grid.view.AbstractGridResource;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResourceAttributeKey;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.support.tooltip.MouseClientTooltipComponent;
import com.ultramega.refinedtypes.registry.Types;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import com.ultramega.refinedtypes.type.energy.EnergyResourceType;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;

public class EnergyGridResource
extends AbstractGridResource<EnergyResource> {
    private final int id;
    private final ResourceRendering rendering;
    private final List<Component> tooltip;

    public EnergyGridResource(EnergyResource resource, String name, Function<GridResourceAttributeKey, Set<String>> attributes) {
        super((PlatformResourceKey)resource, name, attributes);
        this.id = Types.TYPE_REGISTRY.getId((Object)resource.type());
        this.rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(EnergyResource.class);
        this.tooltip = List.of(resource.type().getDisplayName());
    }

    public int getRegistryId() {
        return this.id;
    }

    public List<ClientTooltipComponent> getExtractionHints(ItemStack carriedStack, ResourceRepository<GridResource> repository) {
        ItemStack modifiedStack = carriedStack.copy();
        return Optional.ofNullable((ILongEnergyStorage)modifiedStack.getCapability(ILongEnergyStorage.ITEM)).map(handler -> handler.receive(Platform.INSTANCE.getBucketAmount(), false)).filter(inserted -> inserted > 0L).map(inserted -> MouseClientTooltipComponent.item((MouseClientTooltipComponent.Type)MouseClientTooltipComponent.Type.LEFT, (ItemStack)modifiedStack, null)).stream().toList();
    }

    @Nullable
    public ResourceAmount getAutocraftingRequest() {
        return new ResourceAmount((ResourceKey)this.resource, Platform.INSTANCE.getBucketAmount());
    }

    public boolean canExtract(ItemStack carriedStack, ResourceRepository<GridResource> repository) {
        if (this.getAmount(repository) == 0L) {
            return false;
        }
        if (carriedStack.isEmpty()) {
            return true;
        }
        long toFill = repository.getAmount((ResourceKey)this.resource);
        return Optional.ofNullable((ILongEnergyStorage)carriedStack.getCapability(ILongEnergyStorage.ITEM)).map(handler -> handler.receive(toFill, true)).map(inserted -> inserted > 0L).orElse(false);
    }

    public void onExtract(GridExtractMode extractMode, boolean cursor, GridExtractionStrategy extractionStrategy) {
        extractionStrategy.onExtract(this.resource, extractMode, cursor);
    }

    public void onScroll(GridScrollMode scrollMode, GridScrollingStrategy scrollingStrategy) {
    }

    public void render(GuiGraphics graphics, int x, int y) {
        this.rendering.render((ResourceKey)this.resource, graphics, x, y);
    }

    public String getDisplayedAmount(ResourceRepository<GridResource> repository) {
        return this.rendering.formatAmount(this.getAmount(repository), true);
    }

    public String getAmountInTooltip(ResourceRepository<GridResource> repository) {
        return this.rendering.formatAmount(this.getAmount(repository));
    }

    public boolean belongsToResourceType(ResourceType resourceType) {
        return resourceType == EnergyResourceType.INSTANCE;
    }

    public List<Component> getTooltip() {
        return this.tooltip;
    }

    public Optional<TooltipComponent> getTooltipImage() {
        return Optional.empty();
    }
}

