/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.networkenergizer;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.energy.EnergyProvider;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import javax.annotation.Nullable;

public class NetworkEnergizerNetworkNode
extends AbstractNetworkNode
implements EnergyProvider {
    @Nullable
    private EnergyStorage energyStorage;

    public void setEnergyStorage(@Nullable EnergyStorage energyStorage) {
        this.energyStorage = energyStorage;
    }

    public long getStored() {
        if (!this.isActive()) {
            return 0L;
        }
        if (this.network != null) {
            StorageNetworkComponent storageComponent = (StorageNetworkComponent)this.network.getComponent(StorageNetworkComponent.class);
            long stored = storageComponent.get((ResourceKey)EnergyResource.createEnergyResource());
            if (stored <= 0L && this.energyStorage != null) {
                stored = this.energyStorage.getStored();
            }
            return stored;
        }
        return 0L;
    }

    public long getCapacity() {
        if (!this.isActive()) {
            return 0L;
        }
        return Long.MAX_VALUE;
    }

    public long extract(long amount) {
        if (amount <= 0L) {
            return 0L;
        }
        if (this.network != null) {
            StorageNetworkComponent storageComponent = (StorageNetworkComponent)this.network.getComponent(StorageNetworkComponent.class);
            long extracted = storageComponent.extract((ResourceKey)EnergyResource.createEnergyResource(), amount, Action.EXECUTE, Actor.EMPTY);
            if (extracted <= 0L && this.energyStorage != null) {
                extracted = this.energyStorage.extract(amount, Action.EXECUTE);
            }
            return extracted;
        }
        return 0L;
    }

    public long getEnergyUsage() {
        return 0L;
    }
}

