/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.type.soul;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.refinedtypes.type.Type;
import com.ultramega.refinedtypes.type.soul.SoulResource;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class SoulResourceRendering
implements ResourceRendering {
    private static final DecimalFormat FORMATTER = new DecimalFormat("#,###.###", DecimalFormatSymbols.getInstance(Locale.US));
    private final List<GuiParticle> particleList = new ArrayList<GuiParticle>();
    private long lastCheckedForParticle;

    public String formatAmount(long amount, boolean withUnits) {
        return !withUnits ? SoulResourceRendering.format(amount) : IdentifierUtil.formatWithUnits((double)amount);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component getDisplayName(ResourceKey resourceKey) {
        if (!(resourceKey instanceof SoulResource)) return Component.empty();
        SoulResource soulResource = (SoulResource)resourceKey;
        try {
            Type type;
            Type type2 = type = soulResource.type();
            return type2.getDisplayName();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Component> getTooltip(ResourceKey resourceKey) {
        Type type2;
        if (!(resourceKey instanceof SoulResource)) return Collections.emptyList();
        SoulResource soulResource = (SoulResource)resourceKey;
        try {
            Type type;
            type2 = type = soulResource.type();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return List.of(type2.getDisplayName());
    }

    public void render(ResourceKey resourceKey, GuiGraphics graphics, int x, int y) {
        if (resourceKey instanceof SoulResource) {
            this.render(graphics, x, y);
        }
    }

    public void render(ResourceKey resourceKey, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, Level level) {
    }

    public void render(GuiGraphics graphics, int x, int y) {
        graphics.pose().pushPose();
        ResourceLocation wardenTexture = ResourceLocation.withDefaultNamespace((String)"textures/entity/warden/warden.png");
        ResourceLocation wardenHeart = ResourceLocation.withDefaultNamespace((String)"textures/entity/warden/warden_heart.png");
        graphics.blit(wardenTexture, x, y, 12.0f, 14.0f, 16, 16, 128, 128);
        graphics.pose().pushPose();
        float heartTiming = 30.0f;
        heartTiming = 1.0f - (float)Minecraft.getInstance().level.getGameTime() % heartTiming / heartTiming;
        RenderSystem.setShaderColor((float)heartTiming, (float)heartTiming, (float)heartTiming, (float)heartTiming);
        graphics.blit(wardenHeart, x - 1, y - 1, 11.0f, 13.0f, 18, 18, 128, 128);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.pose().popPose();
        long rotation = Minecraft.getInstance().level.getGameTime() % 160L - 80L;
        graphics.pose().pushPose();
        graphics.pose().translate((float)x, (float)(y - 1), 100.0f);
        graphics.pose().mulPose(Axis.YP.rotationDegrees((float)rotation));
        graphics.blit(wardenTexture, 0, 0, 91.0f, 13.0f, 17, 18, 128, 128);
        graphics.pose().popPose();
        graphics.pose().pushPose();
        graphics.pose().translate((float)(x + 16), (float)(y + 17), 100.0f);
        graphics.pose().mulPose(Axis.ZP.rotationDegrees(180.0f));
        graphics.pose().mulPose(Axis.YP.rotationDegrees((float)rotation));
        graphics.blit(wardenTexture, 0, 0, 91.0f, 13.0f, 17, 18, 128, 128);
        graphics.pose().popPose();
        graphics.pose().scale(0.75f, 0.75f, 0.75f);
        double fullAmount = 0.05;
        int xSize = 8;
        int ySize = 6;
        long currentTime = Minecraft.getInstance().level.getGameTime();
        if (this.lastCheckedForParticle != currentTime) {
            if (Minecraft.getInstance().level.random.nextDouble() <= 0.05) {
                this.particleList.add(new GuiParticle(Minecraft.getInstance().level.random.nextInt(8), 6 - Minecraft.getInstance().level.random.nextInt(3), currentTime));
            }
            this.lastCheckedForParticle = currentTime;
        }
        int ageTick = 3;
        if (currentTime % 3L == 0L) {
            this.particleList.removeIf(guiParticle -> (currentTime - guiParticle.age) / 3L > 10L);
        }
        graphics.pose().translate(0.0f, 0.0f, 200.0f);
        for (GuiParticle guiParticle2 : this.particleList.reversed()) {
            double particleAge = (double)(currentTime - guiParticle2.age) / 3.0;
            double extraY = -1.3 * particleAge;
            graphics.blit(ResourceLocation.withDefaultNamespace((String)("textures/particle/sculk_soul_" + Math.max(0, Math.min(10, (int)particleAge)) + ".png")), (int)((float)(x + guiParticle2.x) * 1.3333334f), (int)((float)((int)((double)(y + guiParticle2.y) + extraY)) * 1.3333334f), 0.0f, 0.0f, 16, 16, 16, 16);
        }
        graphics.pose().popPose();
    }

    public static String format(long amount) {
        return FORMATTER.format(amount);
    }

    private record GuiParticle(int x, int y, long age) {
    }
}

