/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes;

import com.ultramega.refinedtypes.RefinedTypesUtil;
import net.neoforged.neoforge.common.ModConfigSpec;

public final class Config {
    private final ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
    private final ModConfigSpec spec;
    private final EnergyStorageBlockEntry energyStorageBlock = new EnergyStorageBlockEntry(this);
    private final SourceStorageBlockEntry sourceStorageBlock = new SourceStorageBlockEntry(this);
    private final SoulStorageBlockEntry soulStorageBlock = new SoulStorageBlockEntry(this);

    public Config() {
        this.spec = this.builder.build();
    }

    private static String translationKey(String value) {
        return RefinedTypesUtil.createRefinedTypesTranslationKey("config", "option." + value);
    }

    public EnergyStorageBlockEntry getEnergyStorageBlock() {
        return this.energyStorageBlock;
    }

    public SourceStorageBlockEntry getSourceStorageBlock() {
        return this.sourceStorageBlock;
    }

    public SoulStorageBlockEntry getSoulStorageBlock() {
        return this.soulStorageBlock;
    }

    public ModConfigSpec getSpec() {
        return this.spec;
    }

    public class EnergyStorageBlockEntry {
        private final ModConfigSpec.LongValue k64EnergyUsage;
        private final ModConfigSpec.LongValue k256EnergyUsage;
        private final ModConfigSpec.LongValue k1024EnergyUsage;
        private final ModConfigSpec.LongValue k8192EnergyUsage;
        private final ModConfigSpec.LongValue k65536EnergyUsage;
        private final ModConfigSpec.LongValue k262144EnergyUsage;
        private final ModConfigSpec.LongValue k1048576EnergyUsage;
        private final ModConfigSpec.LongValue k8388608EnergyUsage;
        private final ModConfigSpec.LongValue infiniteEnergyUsage;

        EnergyStorageBlockEntry(Config this$0) {
            this$0.builder.translation(Config.translationKey("energyStorageBlock")).push("energyStorageBlock");
            this.k64EnergyUsage = this$0.builder.translation(Config.translationKey("energyStorageBlock.64KEnergyUsage")).defineInRange("64KEnergyUsage", 2L, 0L, Long.MAX_VALUE);
            this.k256EnergyUsage = this$0.builder.translation(Config.translationKey("energyStorageBlock.256KEnergyUsage")).defineInRange("256KEnergyUsage", 4L, 0L, Long.MAX_VALUE);
            this.k1024EnergyUsage = this$0.builder.translation(Config.translationKey("energyStorageBlock.1024KEnergyUsage")).defineInRange("1024KEnergyUsage", 6L, 0L, Long.MAX_VALUE);
            this.k8192EnergyUsage = this$0.builder.translation(Config.translationKey("energyStorageBlock.8192KEnergyUsage")).defineInRange("8192KEnergyUsage", 8L, 0L, Long.MAX_VALUE);
            this.k65536EnergyUsage = this$0.builder.translation(Config.translationKey("energyStorageBlock.65536KEnergyUsage")).defineInRange("65536KEnergyUsage", 10L, 0L, Long.MAX_VALUE);
            this.k262144EnergyUsage = this$0.builder.translation(Config.translationKey("energyStorageBlock.262144KEnergyUsage")).defineInRange("262144KEnergyUsage", 12L, 0L, Long.MAX_VALUE);
            this.k1048576EnergyUsage = this$0.builder.translation(Config.translationKey("energyStorageBlock.1048576KEnergyUsage")).defineInRange("1048576KEnergyUsage", 14L, 0L, Long.MAX_VALUE);
            this.k8388608EnergyUsage = this$0.builder.translation(Config.translationKey("energyStorageBlock.8388608KEnergyUsage")).defineInRange("8388608KEnergyUsage", 16L, 0L, Long.MAX_VALUE);
            this.infiniteEnergyUsage = this$0.builder.translation(Config.translationKey("energyStorageBlock.infiniteEnergyUsage")).defineInRange("infiniteEnergyUsage", 18L, 0L, Long.MAX_VALUE);
            this$0.builder.pop();
        }

        public long get64KEnergyUsage() {
            return (Long)this.k64EnergyUsage.get();
        }

        public long get256KEnergyUsage() {
            return (Long)this.k256EnergyUsage.get();
        }

        public long get1024KEnergyUsage() {
            return (Long)this.k1024EnergyUsage.get();
        }

        public long get8192KEnergyUsage() {
            return (Long)this.k8192EnergyUsage.get();
        }

        public long get65536KEnergyUsage() {
            return (Long)this.k65536EnergyUsage.get();
        }

        public long get262144KEnergyUsage() {
            return (Long)this.k262144EnergyUsage.get();
        }

        public long get1048576KEnergyUsage() {
            return (Long)this.k1048576EnergyUsage.get();
        }

        public long get8388608KEnergyUsage() {
            return (Long)this.k8388608EnergyUsage.get();
        }

        public long getInfiniteEnergyUsage() {
            return (Long)this.infiniteEnergyUsage.get();
        }
    }

    public class SourceStorageBlockEntry {
        private final ModConfigSpec.LongValue b64SourceUsage;
        private final ModConfigSpec.LongValue b256SourceUsage;
        private final ModConfigSpec.LongValue b1024SourceUsage;
        private final ModConfigSpec.LongValue b8192SourceUsage;
        private final ModConfigSpec.LongValue b65536SourceUsage;
        private final ModConfigSpec.LongValue b262144SourceUsage;
        private final ModConfigSpec.LongValue b1048576SourceUsage;
        private final ModConfigSpec.LongValue b8388608SourceUsage;
        private final ModConfigSpec.LongValue infiniteSourceUsage;

        SourceStorageBlockEntry(Config this$0) {
            this$0.builder.translation(Config.translationKey("sourceStorageBlock")).push("sourceStorageBlock");
            this.b64SourceUsage = this$0.builder.translation(Config.translationKey("sourceStorageBlock.64BSourceUsage")).defineInRange("64BSourceUsage", 2L, 0L, Long.MAX_VALUE);
            this.b256SourceUsage = this$0.builder.translation(Config.translationKey("sourceStorageBlock.256BSourceUsage")).defineInRange("256BSourceUsage", 4L, 0L, Long.MAX_VALUE);
            this.b1024SourceUsage = this$0.builder.translation(Config.translationKey("sourceStorageBlock.1024BSourceUsage")).defineInRange("1024BSourceUsage", 6L, 0L, Long.MAX_VALUE);
            this.b8192SourceUsage = this$0.builder.translation(Config.translationKey("sourceStorageBlock.8192BSourceUsage")).defineInRange("8192BSourceUsage", 8L, 0L, Long.MAX_VALUE);
            this.b65536SourceUsage = this$0.builder.translation(Config.translationKey("sourceStorageBlock.65536BSourceUsage")).defineInRange("65536BSourceUsage", 10L, 0L, Long.MAX_VALUE);
            this.b262144SourceUsage = this$0.builder.translation(Config.translationKey("sourceStorageBlock.262144BSourceUsage")).defineInRange("262144BSourceUsage", 12L, 0L, Long.MAX_VALUE);
            this.b1048576SourceUsage = this$0.builder.translation(Config.translationKey("sourceStorageBlock.1048576BSourceUsage")).defineInRange("1048576BSourceUsage", 14L, 0L, Long.MAX_VALUE);
            this.b8388608SourceUsage = this$0.builder.translation(Config.translationKey("sourceStorageBlock.8388608BSourceUsage")).defineInRange("8388608BSourceUsage", 16L, 0L, Long.MAX_VALUE);
            this.infiniteSourceUsage = this$0.builder.translation(Config.translationKey("sourceStorageBlock.infiniteSourceUsage")).defineInRange("infiniteSourceUsage", 18L, 0L, Long.MAX_VALUE);
            this$0.builder.pop();
        }

        public long get64BSourceUsage() {
            return (Long)this.b64SourceUsage.get();
        }

        public long get256BSourceUsage() {
            return (Long)this.b256SourceUsage.get();
        }

        public long get1024BSourceUsage() {
            return (Long)this.b1024SourceUsage.get();
        }

        public long get8192BSourceUsage() {
            return (Long)this.b8192SourceUsage.get();
        }

        public long get65536BSourceUsage() {
            return (Long)this.b65536SourceUsage.get();
        }

        public long get262144BSourceUsage() {
            return (Long)this.b262144SourceUsage.get();
        }

        public long get1048576BSourceUsage() {
            return (Long)this.b1048576SourceUsage.get();
        }

        public long get8388608BSourceUsage() {
            return (Long)this.b8388608SourceUsage.get();
        }

        public long getInfiniteSourceUsage() {
            return (Long)this.infiniteSourceUsage.get();
        }
    }

    public class SoulStorageBlockEntry {
        private final ModConfigSpec.LongValue k1EnergyUsage;
        private final ModConfigSpec.LongValue k8EnergyUsage;
        private final ModConfigSpec.LongValue k64EnergyUsage;
        private final ModConfigSpec.LongValue k512EnergyUsage;
        private final ModConfigSpec.LongValue k4096EnergyUsage;
        private final ModConfigSpec.LongValue k32768EnergyUsage;
        private final ModConfigSpec.LongValue k262144EnergyUsage;
        private final ModConfigSpec.LongValue k2097152EnergyUsage;
        private final ModConfigSpec.LongValue infiniteEnergyUsage;

        SoulStorageBlockEntry(Config this$0) {
            this$0.builder.translation(Config.translationKey("soulStorageBlock")).push("soulStorageBlock");
            this.k1EnergyUsage = this$0.builder.translation(Config.translationKey("soulStorageBlock.1KEnergyUsage")).defineInRange("1KEnergyUsage", 2L, 0L, Long.MAX_VALUE);
            this.k8EnergyUsage = this$0.builder.translation(Config.translationKey("soulStorageBlock.8KEnergyUsage")).defineInRange("8KEnergyUsage", 4L, 0L, Long.MAX_VALUE);
            this.k64EnergyUsage = this$0.builder.translation(Config.translationKey("soulStorageBlock.64KEnergyUsage")).defineInRange("64KEnergyUsage", 6L, 0L, Long.MAX_VALUE);
            this.k512EnergyUsage = this$0.builder.translation(Config.translationKey("soulStorageBlock.512KEnergyUsage")).defineInRange("512KEnergyUsage", 8L, 0L, Long.MAX_VALUE);
            this.k4096EnergyUsage = this$0.builder.translation(Config.translationKey("soulStorageBlock.4096KEnergyUsage")).defineInRange("4096KEnergyUsage", 10L, 0L, Long.MAX_VALUE);
            this.k32768EnergyUsage = this$0.builder.translation(Config.translationKey("soulStorageBlock.32768KEnergyUsage")).defineInRange("32768KEnergyUsage", 12L, 0L, Long.MAX_VALUE);
            this.k262144EnergyUsage = this$0.builder.translation(Config.translationKey("soulStorageBlock.262144KEnergyUsage")).defineInRange("262144KEnergyUsage", 14L, 0L, Long.MAX_VALUE);
            this.k2097152EnergyUsage = this$0.builder.translation(Config.translationKey("soulStorageBlock.2097152KEnergyUsage")).defineInRange("2097152KEnergyUsage", 16L, 0L, Long.MAX_VALUE);
            this.infiniteEnergyUsage = this$0.builder.translation(Config.translationKey("soulStorageBlock.infiniteEnergyUsage")).defineInRange("infiniteEnergyUsage", 18L, 0L, Long.MAX_VALUE);
            this$0.builder.pop();
        }

        public long get1KEnergyUsage() {
            return (Long)this.k1EnergyUsage.get();
        }

        public long get8KEnergyUsage() {
            return (Long)this.k8EnergyUsage.get();
        }

        public long get64KEnergyUsage() {
            return (Long)this.k64EnergyUsage.get();
        }

        public long get512KEnergyUsage() {
            return (Long)this.k512EnergyUsage.get();
        }

        public long get4096KEnergyUsage() {
            return (Long)this.k4096EnergyUsage.get();
        }

        public long get32768KEnergyUsage() {
            return (Long)this.k32768EnergyUsage.get();
        }

        public long get262144KEnergyUsage() {
            return (Long)this.k262144EnergyUsage.get();
        }

        public long get2097152KEnergyUsage() {
            return (Long)this.k2097152EnergyUsage.get();
        }

        public long getInfiniteEnergyUsage() {
            return (Long)this.infiniteEnergyUsage.get();
        }
    }
}

