/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.type.energy;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridOperationsImpl;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.storage.StorageType;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.storage.SameTypeStorageType;
import com.ultramega.refinedtypes.RefinedTypesUtil;
import com.ultramega.refinedtypes.registry.Types;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public enum EnergyResourceType implements ResourceType
{
    INSTANCE;

    public static final MapCodec<EnergyResource> MAP_CODEC;
    public static final Codec<EnergyResource> CODEC;
    public static final StreamCodec<RegistryFriendlyByteBuf, EnergyResource> STREAM_CODEC;
    public static final StorageType STORAGE_TYPE;
    private static final MutableComponent TITLE;
    private static final ResourceLocation SPRITE;

    public MapCodec<PlatformResourceKey> getMapCodec() {
        return MAP_CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, PlatformResourceKey> getStreamCodec() {
        return STREAM_CODEC;
    }

    public MutableComponent getTitle() {
        return TITLE;
    }

    public ResourceLocation getSprite() {
        return SPRITE;
    }

    public long normalizeAmount(double amount) {
        return (long)amount;
    }

    public double getDisplayAmount(long amount) {
        return amount;
    }

    public long getInterfaceExportLimit() {
        return Platform.INSTANCE.getBucketAmount() * 1000L;
    }

    public GridOperations createGridOperations(RootStorage rootStorage, Actor actor) {
        return new GridOperationsImpl(rootStorage, actor, resource -> Long.MAX_VALUE, Platform.INSTANCE.getBucketAmount());
    }

    static {
        MAP_CODEC = RecordCodecBuilder.mapCodec(ins -> ins.group((App)Types.CODEC.fieldOf("energy").forGetter(EnergyResource::type)).apply((Applicative)ins, EnergyResource::new));
        CODEC = MAP_CODEC.codec();
        STREAM_CODEC = StreamCodec.composite(Types.STREAM_CODEC, EnergyResource::type, EnergyResource::new);
        STORAGE_TYPE = new SameTypeStorageType(CODEC, resource -> resource instanceof EnergyResource, EnergyResource.class::cast, Platform.INSTANCE.getBucketAmount(), Platform.INSTANCE.getBucketAmount() * 64L);
        TITLE = RefinedTypesUtil.createRefinedTypesTranslation("misc", "resource_type.energy");
        SPRITE = RefinedTypesUtil.createRefinedTypesIdentifier("energy_resource_type");
    }
}

