/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.compat.emi;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.ultramega.refinedtypes.RefinedTypesUtil;
import com.ultramega.refinedtypes.registry.Types;
import com.ultramega.refinedtypes.type.Type;
import com.ultramega.refinedtypes.type.TypeStack;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import com.ultramega.refinedtypes.type.soul.SoulResource;
import com.ultramega.refinedtypes.type.source.SourceResource;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TypeEmiStack
extends EmiStack {
    private final Type type;
    private final ResourceRendering rendering;
    private final PlatformResourceKey resource;

    public TypeEmiStack(Type type, long amount) {
        this.type = type;
        this.amount = amount;
        if (this.type == Types.FE.get()) {
            this.rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(EnergyResource.class);
            this.resource = EnergyResource.createEnergyResource();
        } else if (this.type == Types.SOURCE.get()) {
            this.rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(SourceResource.class);
            this.resource = SourceResource.createSourceResource();
        } else if (this.type == Types.SOUL.get()) {
            this.rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(SoulResource.class);
            this.resource = SoulResource.createSoulResource();
        } else {
            throw new RuntimeException("Invalid resource type " + String.valueOf(type));
        }
    }

    public EmiStack copy() {
        return new TypeEmiStack(this.type, this.amount);
    }

    public void render(GuiGraphics graphics, int x, int y, float delta, int flags) {
        this.rendering.render((ResourceKey)this.resource, graphics, x, y);
    }

    public boolean isEmpty() {
        return this.amount <= 0L;
    }

    public DataComponentPatch getComponentChanges() {
        return DataComponentPatch.EMPTY;
    }

    public Object getKey() {
        return this.type.name();
    }

    public ResourceLocation getId() {
        return RefinedTypesUtil.createRefinedTypesIdentifier(this.type.name());
    }

    public List<Component> getTooltipText() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        return List.of(this.getName());
    }

    public List<ClientTooltipComponent> getTooltip() {
        List<ClientTooltipComponent> tooltips = this.getTooltipText().stream().map(EmiTooltipComponents::of).collect(Collectors.toList());
        if (this.amount > 1L) {
            tooltips.add(EmiTooltipComponents.of((Component)Component.literal((String)this.rendering.formatAmount(this.amount))));
        }
        EmiTooltipComponents.appendModName(tooltips, (String)this.getId().getNamespace());
        tooltips.addAll(super.getTooltip());
        return tooltips;
    }

    public Component getName() {
        return this.type.getDisplayName();
    }

    @Nullable
    public TypeStack getStack() {
        if (this.isEmpty()) {
            return null;
        }
        return new TypeStack(this.type, this.amount);
    }

    public PlatformResourceKey getResource() {
        return this.resource;
    }
}

