/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.registry;

import com.ultramega.refinedtypes.storage.energy.EnergyStorageVariant;
import com.ultramega.refinedtypes.storage.soul.SoulStorageVariant;
import com.ultramega.refinedtypes.storage.source.SourceStorageVariant;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;

public final class Items {
    private static final Map<EnergyStorageVariant, Supplier<Item>> ENERGY_STORAGE_PARTS = new EnumMap<EnergyStorageVariant, Supplier<Item>>(EnergyStorageVariant.class);
    private static final Map<EnergyStorageVariant, Supplier<Item>> ENERGY_STORAGE_DISKS = new EnumMap<EnergyStorageVariant, Supplier<Item>>(EnergyStorageVariant.class);
    private static final Map<EnergyStorageVariant, Supplier<Item>> ENERGY_STORAGE_BLOCKS = new EnumMap<EnergyStorageVariant, Supplier<Item>>(EnergyStorageVariant.class);
    private static final Map<SourceStorageVariant, Supplier<Item>> SOURCE_STORAGE_PARTS = new EnumMap<SourceStorageVariant, Supplier<Item>>(SourceStorageVariant.class);
    private static final Map<SourceStorageVariant, Supplier<Item>> SOURCE_STORAGE_DISKS = new EnumMap<SourceStorageVariant, Supplier<Item>>(SourceStorageVariant.class);
    private static final Map<SourceStorageVariant, Supplier<Item>> SOURCE_STORAGE_BLOCKS = new EnumMap<SourceStorageVariant, Supplier<Item>>(SourceStorageVariant.class);
    private static final Map<SoulStorageVariant, Supplier<Item>> SOUL_STORAGE_PARTS = new EnumMap<SoulStorageVariant, Supplier<Item>>(SoulStorageVariant.class);
    private static final Map<SoulStorageVariant, Supplier<Item>> SOUL_STORAGE_DISKS = new EnumMap<SoulStorageVariant, Supplier<Item>>(SoulStorageVariant.class);
    private static final Map<SoulStorageVariant, Supplier<Item>> SOUL_STORAGE_BLOCKS = new EnumMap<SoulStorageVariant, Supplier<Item>>(SoulStorageVariant.class);

    private Items() {
    }

    public static Item getEnergyStoragePart(EnergyStorageVariant variant) {
        return ENERGY_STORAGE_PARTS.get((Object)variant).get();
    }

    public static void setEnergyStoragePart(EnergyStorageVariant variant, Supplier<Item> supplier) {
        ENERGY_STORAGE_PARTS.put(variant, supplier);
    }

    public static Item getEnergyStorageDisk(EnergyStorageVariant variant) {
        return ENERGY_STORAGE_DISKS.get((Object)variant).get();
    }

    public static void setEnergyStorageDisk(EnergyStorageVariant variant, Supplier<Item> supplier) {
        ENERGY_STORAGE_DISKS.put(variant, supplier);
    }

    public static Item getEnergyStorageBlock(EnergyStorageVariant variant) {
        return ENERGY_STORAGE_BLOCKS.get((Object)variant).get();
    }

    public static void setEnergyStorageBlock(EnergyStorageVariant variant, Supplier<Item> supplier) {
        ENERGY_STORAGE_BLOCKS.put(variant, supplier);
    }

    public static Item getSourceStoragePart(SourceStorageVariant variant) {
        return SOURCE_STORAGE_PARTS.get((Object)variant).get();
    }

    public static void setSourceStoragePart(SourceStorageVariant variant, Supplier<Item> supplier) {
        SOURCE_STORAGE_PARTS.put(variant, supplier);
    }

    public static Item getSourceStorageDisk(SourceStorageVariant variant) {
        return SOURCE_STORAGE_DISKS.get((Object)variant).get();
    }

    public static void setSourceStorageDisk(SourceStorageVariant variant, Supplier<Item> supplier) {
        SOURCE_STORAGE_DISKS.put(variant, supplier);
    }

    public static Item getSourceStorageBlock(SourceStorageVariant variant) {
        return SOURCE_STORAGE_BLOCKS.get((Object)variant).get();
    }

    public static void setSourceStorageBlock(SourceStorageVariant variant, Supplier<Item> supplier) {
        SOURCE_STORAGE_BLOCKS.put(variant, supplier);
    }

    public static Item getSoulStoragePart(SoulStorageVariant variant) {
        return SOUL_STORAGE_PARTS.get((Object)variant).get();
    }

    public static void setSoulStoragePart(SoulStorageVariant variant, Supplier<Item> supplier) {
        SOUL_STORAGE_PARTS.put(variant, supplier);
    }

    public static Item getSoulStorageDisk(SoulStorageVariant variant) {
        return SOUL_STORAGE_DISKS.get((Object)variant).get();
    }

    public static void setSoulStorageDisk(SoulStorageVariant variant, Supplier<Item> supplier) {
        SOUL_STORAGE_DISKS.put(variant, supplier);
    }

    public static Item getSoulStorageBlock(SoulStorageVariant variant) {
        return SOUL_STORAGE_BLOCKS.get((Object)variant).get();
    }

    public static void setSoulStorageBlock(SoulStorageVariant variant, Supplier<Item> supplier) {
        SOUL_STORAGE_BLOCKS.put(variant, supplier);
    }
}

