/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.storage.soul;

import com.buuz135.industrialforegoingsouls.capabilities.ISoulHandler;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.ultramega.refinedtypes.type.soul.SoulResource;
import com.ultramega.refinedtypes.type.soul.SoulResourceType;

public record ResourceContainerSoulHandlerAdapter(ResourceContainer container) implements ISoulHandler
{
    public int fill(int amount, ISoulHandler.Action action) {
        for (int i = 0; i < this.container.size(); ++i) {
            int received;
            ResourceAmount currentResource = this.container.get(i);
            if (currentResource == null) {
                return (int)this.insertSoulInEmptySlot(i, amount, action);
            }
            if (!(currentResource.resource() instanceof SoulResource) || (received = (int)this.insertSoulInFilledSlot(i, amount, action, currentResource)) <= 0) continue;
            return received;
        }
        return 0;
    }

    private long insertSoulInFilledSlot(int index, long maxReceive, ISoulHandler.Action action, ResourceAmount currentResource) {
        long currentAmount = currentResource.amount();
        long toInsert = Math.min(maxReceive, SoulResourceType.INSTANCE.getInterfaceExportLimit() - currentAmount);
        if (toInsert <= 0L) {
            return 0L;
        }
        if (action == ISoulHandler.Action.EXECUTE) {
            this.container.set(index, new ResourceAmount(currentResource.resource(), currentAmount + toInsert));
        }
        return toInsert;
    }

    private long insertSoulInEmptySlot(int tank, long maxReceive, ISoulHandler.Action action) {
        long toInsert = Math.min(maxReceive, SoulResourceType.INSTANCE.getInterfaceExportLimit());
        if (toInsert <= 0L) {
            return 0L;
        }
        if (action == ISoulHandler.Action.EXECUTE) {
            this.container.set(tank, new ResourceAmount((ResourceKey)SoulResource.createSoulResource(), toInsert));
        }
        return toInsert;
    }

    public int drain(int maxDrain, ISoulHandler.Action action) {
        if (maxDrain <= 0) {
            return 0;
        }
        for (int i = 0; i < this.container.size(); ++i) {
            ResourceAmount resourceAmount = this.container.get(i);
            if (resourceAmount == null || !(resourceAmount.resource() instanceof SoulResource)) continue;
            long available = resourceAmount.amount();
            if (available <= 0L) {
                return 0;
            }
            int toExtract = (int)Math.min((long)maxDrain, available);
            if (action == ISoulHandler.Action.EXECUTE) {
                this.container.shrink(i, (long)toExtract);
            }
            return toExtract;
        }
        return 0;
    }

    public int getSoulTanks() {
        return this.container.size();
    }

    public int getSoulInTank(int tank) {
        ResourceAmount resourceAmount = this.container.get(tank);
        if (resourceAmount == null || !(resourceAmount.resource() instanceof SoulResource)) {
            return 0;
        }
        return (int)resourceAmount.amount();
    }

    public int getTankCapacity(int tank) {
        PlatformResourceKey resource = this.container.getResource(tank);
        if (resource == null || resource instanceof SoulResource) {
            return (int)SoulResourceType.INSTANCE.getInterfaceExportLimit();
        }
        return 0;
    }
}

