/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.storage.soul;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.storage.AbstractStorageContainerBlockItem;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.content.Blocks;
import com.refinedmods.refinedstorage.common.storage.StorageVariant;
import com.refinedmods.refinedstorage.common.storage.UpgradeableStorageContainer;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.refinedtypes.RefinedTypesUtil;
import com.ultramega.refinedtypes.registry.Items;
import com.ultramega.refinedtypes.storage.soul.SoulStorageVariant;
import com.ultramega.refinedtypes.type.soul.SoulResource;
import com.ultramega.refinedtypes.type.soul.SoulResourceType;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class SoulStorageBlockBlockItem
extends AbstractStorageContainerBlockItem
implements UpgradeableStorageContainer {
    private static final Component INFINITE_HELP = RefinedTypesUtil.createRefinedTypesTranslation("item", "infinite_soul_storage_block.help");
    private final SoulStorageVariant variant;
    private final Component helpText;

    public SoulStorageBlockBlockItem(Block block, SoulStorageVariant variant) {
        super(block, new Item.Properties().stacksTo(1).fireResistant(), RefinedStorageApi.INSTANCE.getStorageContainerItemHelper());
        this.variant = variant;
        this.helpText = SoulStorageBlockBlockItem.getHelpText(variant);
    }

    private static Component getHelpText(SoulStorageVariant variant) {
        if (variant.getCapacity() == null) {
            return INFINITE_HELP;
        }
        return RefinedTypesUtil.createRefinedTypesTranslation("item", "soul_storage_block.help", IdentifierUtil.format((long)variant.getCapacity()));
    }

    @Nullable
    protected Long getCapacity() {
        return this.variant.getCapacity();
    }

    protected String formatAmount(long amount) {
        return RefinedStorageClientApi.INSTANCE.getResourceRendering(SoulResource.class).formatAmount(amount);
    }

    protected SerializableStorage createStorage(StorageRepository storageRepository) {
        return SoulStorageBlockBlockItem.createStorage(this.variant, () -> ((StorageRepository)storageRepository).markAsChanged());
    }

    static SerializableStorage createStorage(SoulStorageVariant variant, Runnable listener) {
        return SoulResourceType.STORAGE_TYPE.create(variant.getCapacity(), listener);
    }

    protected ItemStack createPrimaryDisassemblyByproduct(int count) {
        return new ItemStack((ItemLike)Blocks.INSTANCE.getMachineCasing(), count);
    }

    protected ItemStack createSecondaryDisassemblyByproduct(int count) {
        return new ItemStack((ItemLike)Items.getSoulStoragePart(this.variant), count);
    }

    protected boolean placeBlock(BlockPlaceContext ctx, BlockState state) {
        ServerPlayer serverPlayer;
        Player player = ctx.getPlayer();
        if (player instanceof ServerPlayer && !RefinedStorageApi.INSTANCE.canPlaceNetworkNode(serverPlayer = (ServerPlayer)player, ctx.getLevel(), ctx.getClickedPos(), state)) {
            return false;
        }
        return super.placeBlock(ctx, state);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new HelpTooltipComponent(this.helpText));
    }

    public StorageVariant getVariant() {
        return this.variant;
    }

    public void transferTo(ItemStack from, ItemStack to) {
        this.helper.markAsToTransfer(from, to);
    }
}

