/*
 * Decompiled with CFR 0.152.
 */
package dev.doeshing.koukeNekoNametag;

import dev.doeshing.koukeNekoNametag.commands.ReloadCommand;
import dev.doeshing.koukeNekoNametag.commands.TagCommand;
import dev.doeshing.koukeNekoNametag.core.CommandSystem;
import dev.doeshing.koukeNekoNametag.core.MessageManager;
import dev.doeshing.koukeNekoNametag.core.lang.LanguageManager;
import dev.doeshing.koukeNekoNametag.core.tag.CommandTagDisplayService;
import dev.doeshing.koukeNekoNametag.core.tag.CommandTagPermissionService;
import dev.doeshing.koukeNekoNametag.core.tag.FileTagRepository;
import dev.doeshing.koukeNekoNametag.core.tag.TagDisplayService;
import dev.doeshing.koukeNekoNametag.core.tag.TagManager;
import dev.doeshing.koukeNekoNametag.core.tag.TagMenu;
import dev.doeshing.koukeNekoNametag.core.tag.TagPermissionService;
import dev.doeshing.koukeNekoNametag.core.tag.TagRepository;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class KoukeNekoNametag
extends JavaPlugin {
    private MessageManager messageManager;
    private CommandSystem commandSystem;
    private LanguageManager languageManager;
    private TagRepository tagRepository;
    private TagPermissionService tagPermissionService;
    private TagDisplayService tagDisplayService;
    private TagManager tagManager;
    private TagMenu tagMenu;

    public void onEnable() {
        try {
            this.initializeConfiguration();
            this.initializeCoreServices();
            this.initializeTagSystem();
            this.registerCommands();
            this.getLogger().info("KoukeNeko \u6a19\u7c64\u7cfb\u7d71\u5df2\u555f\u7528\uff01");
        }
        catch (Exception e) {
            this.getLogger().severe("\u5916\u639b\u555f\u52d5\u5931\u6557: " + e.getMessage());
            this.getLogger().log(Level.SEVERE, "\u7570\u5e38\u5806\u758a\u8ffd\u8e64: ", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    private void initializeConfiguration() {
        this.saveDefaultConfig();
    }

    private void initializeCoreServices() {
        this.languageManager = new LanguageManager(this);
        this.messageManager = new MessageManager(this);
        this.commandSystem = new CommandSystem(this);
    }

    private void initializeTagSystem() {
        this.tagRepository = new FileTagRepository(this);
        this.tagPermissionService = new CommandTagPermissionService(this);
        this.tagDisplayService = new CommandTagDisplayService(this);
        this.tagManager = new TagManager(this, this.tagRepository, this.tagPermissionService, this.tagDisplayService);
        this.tagMenu = new TagMenu(this, this.tagManager);
    }

    public void onDisable() {
        try {
            this.cleanupResources();
            this.getLogger().info("KoukeNeko \u6a19\u7c64\u7cfb\u7d71\u5df2\u505c\u7528\uff01");
        }
        catch (Exception e) {
            this.getLogger().severe("\u5916\u639b\u505c\u7528\u6642\u767c\u751f\u932f\u8aa4: " + e.getMessage());
            this.getLogger().log(Level.SEVERE, "\u7570\u5e38\u5806\u758a\u8ffd\u8e64: ", e);
        }
    }

    private void cleanupResources() {
    }

    private void registerCommands() {
        this.registerReloadCommand();
        this.registerTagCommand();
    }

    private void registerReloadCommand() {
        this.commandSystem.registerCommand("koukeneko", new ReloadCommand(this), "koukeneko.admin", "KoukeNeko \u63d2\u4ef6\u4e3b\u6307\u4ee4", "/koukeneko reload", "kn");
    }

    private void registerTagCommand() {
        TagCommand tagCommand = new TagCommand(this, this.tagManager, this.tagMenu);
        this.commandSystem.registerCommand("tag", tagCommand, null, "\u6a19\u7c64\u7cfb\u7d71\u6307\u4ee4", "/tag [\u53c3\u6578]", "\u6a19\u7c64", "tags");
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public TagManager getTagManager() {
        return this.tagManager;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public void reloadConfig() {
        try {
            super.reloadConfig();
            this.reloadLanguageSettings();
            this.reloadMessageSettings();
            this.reloadTagSettings();
            this.getLogger().info("\u6240\u6709\u8a2d\u5b9a\u5df2\u91cd\u65b0\u8f09\u5165");
        }
        catch (Exception e) {
            this.getLogger().severe("\u91cd\u65b0\u8f09\u5165\u8a2d\u5b9a\u6a94\u6642\u767c\u751f\u932f\u8aa4: " + e.getMessage());
            this.getLogger().log(Level.SEVERE, "\u7570\u5e38\u5806\u758a\u8ffd\u8e64: ", e);
        }
    }

    private void reloadLanguageSettings() {
        if (this.languageManager != null) {
            this.languageManager.reload();
            this.getLogger().info("\u8a9e\u8a00\u8a2d\u5b9a\u5df2\u91cd\u65b0\u8f09\u5165");
        }
    }

    private void reloadMessageSettings() {
        if (this.messageManager != null) {
            this.messageManager.loadPrefix();
            this.getLogger().info("\u8a0a\u606f\u524d\u7db4\u5df2\u91cd\u65b0\u8f09\u5165");
        }
    }

    private void reloadTagSettings() {
        if (this.tagManager != null) {
            this.tagManager.reload();
            this.getLogger().info("\u6a19\u7c64\u8a2d\u5b9a\u5df2\u91cd\u65b0\u8f09\u5165");
        }
    }
}

