/*
 * Decompiled with CFR 0.152.
 */
package dev.doeshing.koukeNekoNametag.commands;

import dev.doeshing.koukeNekoNametag.KoukeNekoNametag;
import dev.doeshing.koukeNekoNametag.commands.CommandHandler;
import dev.doeshing.koukeNekoNametag.core.tag.Tag;
import dev.doeshing.koukeNekoNametag.core.tag.TagManager;
import java.util.HashMap;
import org.bukkit.command.CommandSender;

public class CreateTagCommandHandler
implements CommandHandler {
    private final KoukeNekoNametag plugin;
    private final TagManager tagManager;

    public CreateTagCommandHandler(KoukeNekoNametag plugin, TagManager tagManager) {
        this.plugin = plugin;
        this.tagManager = tagManager;
    }

    @Override
    public boolean handle(CommandSender sender, String[] args) {
        if (args.length < 3) {
            this.plugin.getMessageManager().sendConfigMessage(sender, "tag.create_usage");
            return true;
        }
        String tagId = args[1];
        String display = args[2];
        if (!Tag.isValidId(tagId)) {
            this.plugin.getMessageManager().sendConfigMessage(sender, "tag.invalid_id");
            return true;
        }
        if (this.tagManager.getTag(tagId) != null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("tag", tagId);
            this.plugin.getMessageManager().sendConfigMessage(sender, "tag.tag_exists", placeholders);
            return true;
        }
        Tag tag = this.tagManager.createTag(tagId, display);
        if (tag != null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("display", tag.getDisplay());
            placeholders.put("id", tag.getId());
            this.plugin.getMessageManager().sendConfigMessage(sender, "tag.created", placeholders);
        } else {
            this.plugin.getMessageManager().sendConfigMessage(sender, "tag.create_failed");
        }
        return true;
    }

    @Override
    public String getCommandName() {
        return "create";
    }

    @Override
    public boolean canHandle(String[] args) {
        return args.length > 0 && "create".equalsIgnoreCase(args[0]);
    }
}

