/*
 * Decompiled with CFR 0.152.
 */
package dev.doeshing.koukeNekoNametag.commands;

import dev.doeshing.koukeNekoNametag.KoukeNekoNametag;
import dev.doeshing.koukeNekoNametag.commands.CommandHandler;
import dev.doeshing.koukeNekoNametag.core.tag.Tag;
import dev.doeshing.koukeNekoNametag.core.tag.TagManager;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PlayerTagCommandHandler
implements CommandHandler {
    private final KoukeNekoNametag plugin;
    private final TagManager tagManager;

    public PlayerTagCommandHandler(KoukeNekoNametag plugin, TagManager tagManager) {
        this.plugin = plugin;
        this.tagManager = tagManager;
    }

    @Override
    public boolean handle(CommandSender sender, String[] args) {
        if (args.length < 3) {
            this.plugin.getMessageManager().sendConfigMessage(sender, "tag.help");
            return true;
        }
        String playerName = args[0];
        String action = args[1].toLowerCase();
        String tagId = args[2];
        Player targetPlayer = this.findTargetPlayer(sender, playerName);
        if (targetPlayer == null) {
            return true;
        }
        Tag tag = this.findTag(sender, tagId);
        if (tag == null) {
            return true;
        }
        switch (action) {
            case "add": {
                return this.handleAddPermission(sender, targetPlayer, tag);
            }
            case "remove": {
                return this.handleRemovePermission(sender, targetPlayer, tag);
            }
        }
        return this.handleUnknownAction(sender, action);
    }

    private Player findTargetPlayer(CommandSender sender, String playerName) {
        Player targetPlayer = Bukkit.getPlayer((String)playerName);
        if (targetPlayer == null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", playerName);
            this.plugin.getMessageManager().sendConfigMessage(sender, "tag.player_not_found", placeholders);
        }
        return targetPlayer;
    }

    private Tag findTag(CommandSender sender, String tagId) {
        Tag tag = this.tagManager.getTag(tagId);
        if (tag == null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("tag", tagId);
            this.plugin.getMessageManager().sendConfigMessage(sender, "tag.tag_not_found", placeholders);
        }
        return tag;
    }

    private boolean handleAddPermission(CommandSender sender, Player targetPlayer, Tag tag) {
        if (this.tagManager.giveTagPermission(targetPlayer, tag)) {
            this.sendPermissionAddedMessage(sender, targetPlayer, tag);
        } else {
            this.plugin.getMessageManager().sendConfigMessage(sender, "tag.tag_add_failed");
        }
        return true;
    }

    private boolean handleRemovePermission(CommandSender sender, Player targetPlayer, Tag tag) {
        if (this.tagManager.removeTagPermission(targetPlayer, tag)) {
            this.sendPermissionRemovedMessage(sender, targetPlayer, tag);
        } else {
            this.plugin.getMessageManager().sendConfigMessage(sender, "tag.tag_remove_failed");
        }
        return true;
    }

    private boolean handleUnknownAction(CommandSender sender, String action) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("action", action);
        this.plugin.getMessageManager().sendConfigMessage(sender, "tag.unknown_action", placeholders);
        this.plugin.getMessageManager().sendConfigMessage(sender, "tag.help");
        return true;
    }

    private void sendPermissionAddedMessage(CommandSender sender, Player targetPlayer, Tag tag) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", targetPlayer.getName());
        placeholders.put("display", tag.getDisplay());
        this.plugin.getMessageManager().sendConfigMessage(sender, "tag.tag_added", placeholders);
        HashMap<String, String> playerPlaceholders = new HashMap<String, String>();
        playerPlaceholders.put("display", tag.getDisplay());
        this.plugin.getMessageManager().sendConfigMessage((CommandSender)targetPlayer, "tag.you_got_tag", playerPlaceholders);
    }

    private void sendPermissionRemovedMessage(CommandSender sender, Player targetPlayer, Tag tag) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", targetPlayer.getName());
        placeholders.put("display", tag.getDisplay());
        this.plugin.getMessageManager().sendConfigMessage(sender, "tag.tag_removed", placeholders);
        HashMap<String, String> playerPlaceholders = new HashMap<String, String>();
        playerPlaceholders.put("display", tag.getDisplay());
        this.plugin.getMessageManager().sendConfigMessage((CommandSender)targetPlayer, "tag.your_tag_removed", playerPlaceholders);
    }

    @Override
    public String getCommandName() {
        return "player-operation";
    }

    @Override
    public boolean canHandle(String[] args) {
        if (args.length >= 3) {
            String action = args[1].toLowerCase();
            return "add".equals(action) || "remove".equals(action);
        }
        return false;
    }
}

