/*
 * Decompiled with CFR 0.152.
 */
package dev.doeshing.koukeNekoNametag.commands;

import dev.doeshing.koukeNekoNametag.KoukeNekoNametag;
import dev.doeshing.koukeNekoNametag.commands.CommandHandler;
import dev.doeshing.koukeNekoNametag.core.tag.Tag;
import dev.doeshing.koukeNekoNametag.core.tag.TagManager;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RemoveTagCommandHandler
implements CommandHandler {
    private final KoukeNekoNametag plugin;
    private final TagManager tagManager;

    public RemoveTagCommandHandler(KoukeNekoNametag plugin, TagManager tagManager) {
        this.plugin = plugin;
        this.tagManager = tagManager;
    }

    @Override
    public boolean handle(CommandSender sender, String[] args) {
        if (args.length < 2) {
            this.plugin.getMessageManager().sendConfigMessage(sender, "tag.remove_usage");
            return true;
        }
        String tagId = args[1];
        Tag tag = this.tagManager.getTag(tagId);
        if (tag == null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("tag", tagId);
            this.plugin.getMessageManager().sendConfigMessage(sender, "tag.tag_not_exists", placeholders);
            return true;
        }
        int affectedPlayers = this.handleOnlinePlayersPermissionRemoval(tag);
        this.handleGlobalPermissionRemoval(tag);
        if (this.tagManager.deleteTag(tagId)) {
            this.sendSuccessMessage(sender, tag, affectedPlayers);
        } else {
            this.plugin.getMessageManager().sendConfigMessage(sender, "tag.delete_failed");
        }
        return true;
    }

    private int handleOnlinePlayersPermissionRemoval(Tag tag) {
        int affectedPlayers = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission(tag.getPermission())) continue;
            this.tagManager.removeTagPermission(player, tag);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("display", tag.getDisplay());
            this.plugin.getMessageManager().sendConfigMessage((CommandSender)player, "tag.tag_deleted_notice", placeholders);
            ++affectedPlayers;
        }
        return affectedPlayers;
    }

    private void handleGlobalPermissionRemoval(Tag tag) {
        List commands = this.plugin.getConfig().getStringList("command.remove_permission_all");
        for (String cmd : commands) {
            cmd = cmd.replace("{tag}", tag.getPermission()).replace("{display}", tag.getDisplay());
            this.plugin.getLogger().info("\u57f7\u884c\u79fb\u9664\u6240\u6709\u73a9\u5bb6\u6a19\u7c64\u6b0a\u9650\u6307\u4ee4: " + cmd);
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd);
        }
    }

    private void sendSuccessMessage(CommandSender sender, Tag tag, int affectedPlayers) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("display", tag.getDisplay());
        placeholders.put("id", tag.getId());
        this.plugin.getMessageManager().sendConfigMessage(sender, "tag.deleted", placeholders);
        if (affectedPlayers > 0) {
            HashMap<String, String> countPlaceholders = new HashMap<String, String>();
            countPlaceholders.put("count", String.valueOf(affectedPlayers));
            this.plugin.getMessageManager().sendConfigMessage(sender, "tag.affected_players", countPlaceholders);
        }
    }

    @Override
    public String getCommandName() {
        return "remove";
    }

    @Override
    public boolean canHandle(String[] args) {
        return args.length > 0 && "remove".equalsIgnoreCase(args[0]);
    }
}

